
 % Copyright (c) 2009 Regents of the SIGNET lab, University of Padova and DOCOMO Communications Laboratories Europe GmbH.
 % All rights reserved.
 %
 % Redistribution and use in source and binary forms, with or without
 % modification, are permitted provided that the following conditions
 % are met:
 % 1. Redistributions of source code must retain the above copyright
 %    notice, this list of conditions and the following disclaimer.
 % 2. Redistributions in binary form must reproduce the above copyright
 %    notice, this list of conditions and the following disclaimer in the
 %    documentation and/or other materials provided with the distribution.
 % 3. Neither the name of the University of Padova (SIGNET lab) nor the 
 %    names of its contributors may be used to endorse or promote products 
 %    derived from this software without specific prior written permission.
 %
 % THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 % "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED 
 % TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 % PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 % CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 % EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 % PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 % OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 % WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 % OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 % ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 

function grid_network(N_side, d_min)

min_d = d_min;
Nn = N_side^2; % Number of nodes
%n = Nn/4; % Numbre od nodes in each quarter of cicle


str = strcat('gridNet_', num2str(Nn),'_',num2str(min_d),'.tcl');
FID = fopen(str,'w+');

nodes = zeros(Nn, 2);
%R = min_d./sqrt(2 -2*cos(pi/(2*n))); % Range of the cicle to guarantee the min_d distance among neighbors
passo = 10;
%nodes(1,:) = [0 0];

val_x = ceil(((N_side-1)*min_d+passo)/100)*100;
val_y = ceil(((N_side-1)*min_d+passo)/100)*100;

fprintf(FID, '$topo load_flatgrid %f %f \n', val_x, val_y);
 
for i=1:1:Nn
    nodes(i,:) = [mod(i-1, N_side)*min_d floor((i-1)/N_side)*min_d];   
    fprintf(FID, '$node_(%d) set X_ %f\n', i-1, nodes(i,1));
    fprintf(FID, '$node_(%d) set Y_ %f\n', i-1, nodes(i,2));
    fprintf(FID, '$node_(%d) set Z_ %f\n', i-1, 0);
end

% nodes(1,:) = c + [0 250];
% nodes(2,:) = c + [0 -250];
% nodes(3,:) = c + [250 0];
% nodes(4,:) = c + [-250 0];
% nodes(5,:) = c + R.*[sqrt(2)/2 sqrt(2)/2];
% nodes(6,:) = c + R.*[-sqrt(2)/2 sqrt(2)/2];
% nodes(7,:) = c + R.*[-sqrt(2)/2 -sqrt(2)/2];
% nodes(8,:) = c + R.*[sqrt(2)/2 -sqrt(2)/2];


%asse = [0:2*pi/100:2*pi];
%asse_x = c(1,1) + R.*cos(asse);
%asse_y = c(1,2) + R.*sin(asse);

close all;
figure(1);
plot(nodes(:,1), nodes(:,2), 'ok');
%hold on;
%plot(c(1,1), c(1,2), 'xr');
%hold on;
%plot(asse_x, asse_y, 'r--');

if Nn > 1
    distance = sqrt((nodes(2,1) - nodes(1,1))^2 + (nodes(2,2)-nodes(1,2))^2)
end

fclose('all');
nodes

    