% Copyright (c) 2009 Regents of the SIGNET lab, University of Padova and DOCOMO Communications Laboratories Europe GmbH.
 % All rights reserved.
 %
 % Redistribution and use in source and binary forms, with or without
 % modification, are permitted provided that the following conditions
 % are met:
 % 1. Redistributions of source code must retain the above copyright
 %    notice, this list of conditions and the following disclaimer.
 % 2. Redistributions in binary form must reproduce the above copyright
 %    notice, this list of conditions and the following disclaimer in the
 %    documentation and/or other materials provided with the distribution.
 % 3. Neither the name of the University of Padova (SIGNET lab) nor the 
 %    names of its contributors may be used to endorse or promote products 
 %    derived from this software without specific prior written permission.
 %
 % THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 % "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED 
 % TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 % PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 % CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 % EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 % PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 % OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 % WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 % OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 % ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
function [ok, neigh] = random_network(Ntot, area_x, area_y, Range, sc)

R = Range;
inf = 3000;
Nn = Ntot; % Number of nodes

nodes = zeros(Nn, 2);

val_x = area_x;
val_y = area_y;


% Positioning the nodes
x = rand*val_x;
y = rand*val_y;
z = 0;      
nodes(1, 1) = x;
nodes(1, 2) = y;


for i=2:1:Nn
    dist_min = 3000;
    disp(i);
    while dist_min > R
        x = rand*val_x;
        y = rand*val_y;
        z = 0;
        dist = distanza(nodes(1:1:i-1,1), x, 0, nodes(1:1:i-1,2), y, 0)
        dist_min = min(dist);
    end
    nodes(i, 1) = x;
    nodes(i, 2) = y;
end


% Check if the network is connected

ok = is_connected(Ntot, Range);

if ok == true
    str = strcat('randomNet_', num2str(Ntot), '_', num2str(sc), '.tcl');
    FID = fopen(str,'w+');
    str1 = strcat('randomNet_', num2str(Ntot), '_', num2str(sc), '.txt');
    FID1 = fopen(str1,'w+');
    
    fprintf(FID, '$topo load_flatgrid %f %f \n', val_x, val_y);

    for i=1:1:Nn    
        fprintf(FID, '$node_(%d) set X_ %f\n', i-1, nodes(i,1));
        fprintf(FID, '$node_(%d) set Y_ %f\n', i-1, nodes(i,2));
        fprintf(FID, '$node_(%d) set Z_ %f\n', i-1, 0);
	fprintf(FID1, '%i %f %f %f \n', i-1, nodes(i,1), nodes(i,2), 0.0);
    end
    
    fclose('all');
    
end


close all;
figure(1);
plot(nodes(:,1), nodes(:,2), 'ok');
