% Copyright (c) 2009 Regents of the SIGNET lab, University of Padova and DOCOMO Communications Laboratories Europe GmbH.
 % All rights reserved.
 %
 % Redistribution and use in source and binary forms, with or without
 % modification, are permitted provided that the following conditions
 % are met:
 % 1. Redistributions of source code must retain the above copyright
 %    notice, this list of conditions and the following disclaimer.
 % 2. Redistributions in binary form must reproduce the above copyright
 %    notice, this list of conditions and the following disclaimer in the
 %    documentation and/or other materials provided with the distribution.
 % 3. Neither the name of the University of Padova (SIGNET lab) nor the 
 %    names of its contributors may be used to endorse or promote products 
 %    derived from this software without specific prior written permission.
 %
 % THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 % "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED 
 % TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 % PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 % CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 % EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 % PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 % OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 % WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 % OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 % ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 
function [ok] = random_network1(Ntot, area_x, area_y, Range, sc)

R = Range;
inf = 3000;
Nn = Ntot; % Number of nodes

nodes = zeros(Nn, 2);

val_x = area_x;
val_y = area_y;


% Positioning the nodes

for i=1:1:Nn
    x = rand*val_x;
    y = rand*val_y;
    z = 0;
    nodes(i, 1) = x;
    nodes(i, 2) = y;
end


% Check if the network is connected

%colored_nodes = 1 + colored(nodes, 1, R);
% neigh = [1];
% 
% while ~isempty(neigh)
%     neigh_tmp = [];
%     for ne = 1:1:length(neigh)
%         dist = distanza(nodes(:,1), nodes(:,1), 0, nodes(ne, 1), nodes(ne, 2), 0)
%         indices = find(dist <= R & dist > 0 & nodes(:, 3) == 0)
%         nodes(indices,3) = 1;
%         neigh_tmp = [neigh_tmp indices'];    
%     end
%     neigh = neigh_tmp;
% end
% 
% ok = 0;
% nodes(:,3)

% if length(find(nodes(:,3) == 1))== Nn 
%     ok = 1;
% end

ok = is_connected(nodes, Range)

if ok == 1
    str = strcat('randomNet_', num2str(Ntot), '_', num2str(sc), '.tcl');
    FID = fopen(str,'w+');
    fprintf(FID, '$topo load_flatgrid %f %f \n', val_x, val_y);

    str1 = strcat('randomNet_', num2str(Ntot), '_', num2str(sc), '.txt');
    FID1 = fopen(str1,'w+');
    
    for i=1:1:Nn    
        fprintf(FID, '$node_(%d) set X_ %f\n', i-1, nodes(i,1));
        fprintf(FID, '$node_(%d) set Y_ %f\n', i-1, nodes(i,2));
        fprintf(FID, '$node_(%d) set Z_ %f\n', i-1, 0);
        fprintf(FID1, '%f ', nodes(i,1));
        fprintf(FID1, '%f ', nodes(i,2));
        fprintf(FID1, '%f \n', 0);
    
        %fprintf(FID, '$node_(%d) set-num-neighbor %f\n', i-1, floor(nodes(i,3)));
    end
    
    fclose('all');
    
end


close all;
figure(1);
plot(nodes(:,1), nodes(:,2), 'ok');
