% Copyright (c) 2009 Regents of the SIGNET lab, University of Padova and DOCOMO Communications Laboratories Europe GmbH.
 % All rights reserved.
 %
 % Redistribution and use in source and binary forms, with or without
 % modification, are permitted provided that the following conditions
 % are met:
 % 1. Redistributions of source code must retain the above copyright
 %    notice, this list of conditions and the following disclaimer.
 % 2. Redistributions in binary form must reproduce the above copyright
 %    notice, this list of conditions and the following disclaimer in the
 %    documentation and/or other materials provided with the distribution.
 % 3. Neither the name of the University of Padova (SIGNET lab) nor the 
 %    names of its contributors may be used to endorse or promote products 
 %    derived from this software without specific prior written permission.
 %
 % THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
 % "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED 
 % TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR 
 % PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR 
 % CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 % EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 % PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; 
 % OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, 
 % WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR 
 % OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF 
 % ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 function [conn] = test(str);

A = load(str);

num_nodes = length(A(:,1));
Range = 250;
nodes = zeros(num_nodes, 2)
nodes(:, 1) = A(:,1);
nodes(:,2) = A(:,2);

checked_node = zeros(1,num_nodes); 
sources = zeros(1,num_nodes);


num_sources = 1
count = 1
sources(1) = 1
checked_node(1) = 1
	

while (num_sources > 0)
	index_ = 0
	tmp_sources = zeros(1,num_nodes);
	for j = 1:1:num_sources
        sources(j)
		for i = 1:1:num_nodes
            
			if (distanza(nodes(sources(j),1), nodes(sources(j),2), 0, nodes(i,1), nodes(i,2), 0) <= Range && checked_node(i) == 0 && sources(j)~=i)
				index_ = index_ + 1;
                checked_node(i) = 1;
                tmp_sources(index_) = i;
				count = count + 1;	
            end
        end
    end
	sources(1:1:index_) = tmp_sources(1:1:index_);
	num_sources = index_;
end	
connectivity = true
if (count < num_nodes)
	connectivity = false
end