#! /bin/bash
## build.sh 
## compilazione latex, bibtex, ecc.
## restituisce file postscript, pdf
## uso
## build.sh [master-latex-file]
## es: build.sh libro
##

#

DEFAULTMAIN=main
# --------------------------


# LMF: latex master file
if (( "$#" <= 0 )) ; then
   # nessun parametro passato
   THISNAME=`echo $0|rev|cut -d/ -f1|rev`
   grep '##' $THISNAME |cut -c3- 
   # default value for LMF
   LMF=$DEFAULTMAIN
   echo "default name issued: $LMF"
else
   LMF=$1
   echo "master file: $LFM"
fi


pu latex

latex $LMF
makeindex -s res/indice.ist $LMF.idx
bibtex $LMF
latex $LMF
latex $LMF

# prepara file postcript e pdf
dvips -Ppdf -G -q -o $LMF.ps $LMF.dvi
# lulu.com 6x9 use the following line
# dvips -T 6in,9in -G -q -o $LMF.ps $LMF.dvi
psnup -2 $LMF.ps $LMF.2p.ps
ps2pdf $LMF.ps 
#ps2pdf $LMF.2p.ps

# cancella file di appoggio creati da latex & c
pu latex
rm $LMF.dvi $LMF.ps $LMF.2p.ps
# cancella file temporanei
pu

# mostra risultato con viewer per file dvi
# xdvi $LMF &
# ggv $LMF.ps &

exit

# prepara zip
 
I=`pwd`
cd ..
zip -r $LMF.`date +%Y-%m-%d`.zip $LMF/
cp  $LMF.`date +%Y-%m-%d`.zip $LMF.zip 
cd $I
