package Temi;
/**{p}
 * -- Temi --
 * Universita' di Padova -
 * Diploma Universitario in Ingegneria Informatica
 * Corso di Fondamenti di Informatica 2
 * Temi d'esame
 */

/**{f}
 * Tachim.java
 * Prima prova intermedia 2001/2002
 * Tema a
 *
 * @version 1.00 01/11/04
 * @author M.Moro DEI UPD
 */

import FI2.Util.FI2Sys;

public class Tachim implements DerivaTempo
{
    private double vel;
    protected double posiz, quantoTemp;
    
    public Tachim(Double posIniz, Float quanto)
    {
        vel = 0;
        posiz = posIniz.doubleValue();
        setUnitaT(quanto.floatValue());
    } 

    public Tachim()
    {
        this(new Double(0.0), new Float(1.0F));
    } 
    
    public void setUnitaT(double quanto)
    {
        quantoTemp = quanto;
    } 
    
    public void aggiorna(double quantita)
    {
        vel = (quantita-posiz) / quantoTemp;
        posiz = quantita;
    } 
    
    public double der()
    {
        return vel;
    } 

    public Double velMs()
    {
        return new Double(vel*1000.0);
    } 

    public String toString()
    {
        return "Tachim: pos(km)="+ posiz + " qt(s)=" + quantoTemp +
          " vel(km/s)=" + der();
    } 

    /**[m][s]
     * metodo di collaudo
     */
    public static void main(String[] args)
    {
        Tachim tm = new Tachim(new Double(11.0), 
          new Float(0.5F));
        
        FI2Sys.out.println(tm);
        for (int i=0; i < 20; i++)
        {
            FI2Sys.out.println("tempo(s)="+(i*0.5)+
              " vel(m/s)="+tm.velMs()); 
            double qu = Math.random()*60.0-30.0;
            tm.aggiorna(qu);
            FI2Sys.out.println("qu(km)="+qu+" "+tm);
        }
    }
} //{c}{a} Tachim

