package Temi;
/**{p}
 * -- Temi --
 * Universita' di Padova -
 * Diploma Universitario in Ingegneria Informatica
 * Corso di Fondamenti di Informatica 2
 * Temi d'esame
 */

/**{f}
 * Livello.java
 * Prima prova intermedia 2001/2002
 * Tema b
 *
 * @version 1.00 01/11/04
 * @author M.Moro DEI UPD
 */

import FI2.Util.FI2Sys;

public class Livello implements Varia
{
    private float varLiv;
    protected float liv, interv;
    
    public Livello(Float livIniz, Double periodo)
    {
        varLiv = 0;
        liv = livIniz.floatValue();
        uTempo(periodo.floatValue());
    } 

    public Livello()
    {
        this(new Float(10.0F), new Double(1.0));
    } 
    
    public void uTempo(float qu)
    {
        interv = qu;
    } 
    
    public void nuovo(float val)
    {
        if (val < 0)
            throw new IllegalArgumentException(
              "Livello negativo illegale:"+val);
        varLiv = (val-liv) / interv;
        liv = val;
    } 
    
    public float variaz()
    {
        return varLiv;
    } 

    public Float varLs()
    {
        return new Float(varLiv*5.0/3.0); // 1hl/min = 100/60 l/s
    } 

    public String toString()
    {
        return "Livello: liv(hl)="+ liv + " qt(min)=" + 
          interv + " var(hl/min)=" + variaz();
    } 

    /**[m][s]
     * metodo di collaudo
     */
    public static void main(String[] args)
    {
        Livello lv = new Livello(new Float(5.0), 
          new Double(0.25D));
        
        FI2Sys.out.println(lv);
        for (int i=0; i < 15; i++)
        {
            FI2Sys.out.println("tempo(min)="+(i*0.25)+
              " var(l/s)="+lv.varLs()); 
            float qu = (float)Math.random()*40.0F;
            lv.nuovo(qu);
            FI2Sys.out.println("qu(hl)="+qu+" "+lv);
        }
    }
} //{c}{a} Livello

