package Temi;
/**{p}
 * -- Temi --
 * Universita' di Padova -
 * Diploma Universitario in Ingegneria Informatica
 * Corso di Fondamenti di Informatica 2
 * Temi d'esame
 */

/**{f}
 * Spazio.java
 * Prima prova intermedia 2001/2002
 * Tema c
 *
 * @version 1.00 01/11/01
 * @author M.Moro DEI UPD
 */

import FI2.Util.FI2Sys;

public class Spazio implements IntegraTempo
{
    private double posiz;
    protected double vel, quanto;
    
    public Spazio(Double posIniz, Float quanto)
    {
        vel = 0;
        posiz = posIniz.doubleValue();
        unitaI(quanto.doubleValue());
    } 

    public Spazio()
    {
        this(new Double(0.0), new Float(1.0F));
    } 
    
    public void unitaI(double tempo)
    {
        quanto = tempo;
    } 
    
    public void setCamp(double val)
    {
        vel = val;
        posiz += vel*quanto;
    } 
    
    public double integra()
    {
        return posiz;
    } 

    public Double posMetri()
    {
        return new Double(posiz*1000.0D);
    } 

    public String toString()
    {
        return "Spazio: vel(km/s)="+ vel + " qt(s)=" + quanto +
          " pos(km)=" + integra();
    } 

    /**[m][s]
     * metodo di collaudo
     */
    public static void main(String[] args)
    {
        Spazio sp = new Spazio(new Double(22.0), 
          new Float(0.5F));
        
        FI2Sys.out.println(sp);
        for (int i=0; i < 20; i++)
        {
            FI2Sys.out.println("tempo(s)="+(i*0.5)+
              " pos(m)="+sp.posMetri()); 
            double qu = Math.random()*20.0-10.0;
            sp.setCamp(qu);
            FI2Sys.out.println("qu(km/s)="+qu+" "+sp);
        }
    }
} //{c}{a} Spazio

