function out = IIRcell(in,fc,B);
% cella MA 1 ordine
% f0 al control rate
% sin audio rate; 

global SpF; %samples per frame
global Fs; %sampling rate
Fc=Fs/SpF; %control rate 

nsamples=length(in);
if (length(fc)==1) fc=fc*ones(1,floor(nsamples/SpF)); end
nframes=length(f0)

if (ceil(nsamples/nframes)<SpF)
   error('la lunghezza di fc (in frames)  incompatibile con la lunghezz di in (in campioni)');
end

[b,a]=baIIR(fc,B);

initstate=zeros(1,2);
out=zeros(1,nframes*SpF);
for (i=1:nframes)
   framein=in(((i-1)*SpF+1):i*SpF);  
   [out(((i-1)*SpF+1):i*SpF),endstate]=filter(b(i,:),a(i,:),framein,initstate);  
   initsate=endstate; %aggiornamento dello stato del filtro
end

