% funzione per la valutazione di coefficienti della cella del II ordine
function [b,a]=abeval(fc,B);

global Fs;
global Fc;

nfilters=length(fc);

R=exp(-(pi.*B)/Fs)
a2=-(2*R.*cos(2*pi*fc/Fs))'
a3=R'.^2
a1=ones(nfilters,1)

%normalizzazione
b1=(1-R).*sqrt(1-2.*R.*cos(2*2*pi.*fc/Fs)+R.*R);
b1=b1';

a=[a1 a2 a3];
b=[b1 zeros(nfilters,1) zeros(nfilters,1)];

figure(1)
for (i=1:nfilters)
 [H,w]=freqz(b(i,:),a(i,:));
 plot(Fs*w/(2*pi),db(H))
 ylabel('db')
 hold on
end
hold off
