function fftplot(sig,t,N)
%function fftplot(sig,t,N)
% fft plot function
%
% sig: input signal
% t  : location of time window (sec)
% N  : points of analysis window

global Fs;

if (size(sig,1)>size(sig,2))
   sig=sig';
end

ts=round(t*Fs);
sigwin=sig(ts:(ts+N-1)).*blackman(N)';
S=fft(sigwin);
fbin=Fs/N;
freqaxis=0:fbin:(Fs/2-fbin);
plot(freqaxis,db(S(1:N/2)))
xlabel('Hz')
ylabel('dB')
