function s = fmoper1(t0,a,fc,fm,I);
% operatore fondamentale per FM 
% a al control rate
% t0 istante iniziale in sec; 
% fc portante (control rate)
% fm modulante (control rate)
% I indice di modulazione (control rate)

global SpF; %samples per frame
global Fs; %sampling rate
Fc=Fs/SpF; %control rate 

nframes=length(a)
if (length(fc)==1) fc=fc*ones(1,nframes); end
if (length(fm)==1) fm=fm*ones(1,nframes); end
if (length(I)==1) I=I*ones(1,nframes).*fm;
 else I=I.*fm;
end
   
s=zeros(1,nframes*SpF);

fma=sinosc(0,ones(1,length(fm)),fm,0);
fca=sinosc(0,fc,zeros(1,length(fc)),(pi/2));
Ia=sinosc(0,I,zeros(1,length(I)),(pi/2));
fa=Ia.*fma+fca;
s=fmosc(t0,a,fa,0);

s=[zeros(1,(t0*Fs-1)) s];
