function s = FMosc(t0,a,f,phi0);
%function s = FMosc(t0,a,f,phi0);
% oscillatore sinusoidale per FM (f ad audio rate)
% a al control rate
% t0 istante iniziale in sec; 

global SpF; %samples per frame
global Fs; %sampling rate
Fc=Fs/SpF; %control rate 

nsamples=length(f)
if (length(a)==1) a=a*ones(1,floor(nsamples/SpF)); end
nframes=length(a)

if (ceil(nsamples/nframes)<SpF)
   error('la lunghezza di a (in frames)  incompatibile con la lunghezz di f (in campioni)');
end

s=zeros(1,nframes*SpF);

lastfreq=f(1);
lastphase=0;
phase=zeros(1,SpF);
for (i=1:nframes)
   for(k=1:SpF)
      phase(k)=lastphase+2*pi*lastfreq/Fs+pi*(f((i-1)*SpF+k)-lastfreq)*(1/Fs);   
      lastphase=phase(k);
      lastfreq=f((i-1)*SpF+k);
   end
   s(((i-1)*SpF+1):i*SpF)=a(i).*sin(phase);  
end
s=[zeros(1,(t0*Fs-1)) s];
