%main

%=============================================================% 

global Fs; 
Fs=22050 % sample rate
ControlW=0.01 % control window (in sec): 10 ms
global SpF;
SpF=round(Fs*ControlW) % samples per Frame 
Fc=Fs/SpF % control rat

L=1; % durata del suono in secondi

t=0:(1/Fs):L; % base temporale
tc=0:(1/Fc):L; % base temporale al control rate 

%==============================================================%

% genera segnali di controllo
fc=envgen([0,5],[600,600]); % pitch della portante
fm=envgen([0,1,1.1,2,2.1,3,3.1,4,4.1,5],[5,5,100,100,200,200,500,500,550,550]); %pitch (a gradini) della modulante
%fm=envgen([0,2.5,2.6,5],[4,4,10,10]);
%fm=envgen([0,5],[2,2]);
fma=sinosc(0,ones(1,length(fm)),fm,0);
fca=sinosc(0,fc,zeros(1,length(fc)),(pi/2));
fa=fca+fma; 
%f=envgen([0,.2,1,1.5,2],[200,250,250,350,200],'cubic');
%a=envgen([0,0.5,4.5,5],[0,1,1,0],'linear');

% genera segnali audio 
s=fmosc(0.5,1,fa,0);

% plot dei risultati
figure(1)
subplot(2,1,1)
plot([1:length(a)],a*max(fa)/max(a),[1:length(a)],fa,':');
subplot(2,1,2)
plot(s)
