%mainadditive

%=============================================================% 

global Fs; 
Fs=22050 % sample rate
ControlW=0.01 % control window (in sec): 10 ms
global SpF;
SpF=round(Fs*ControlW) % samples per Frame 
Fc=Fs/SpF % control rate

L=1; % durata del suono in secondi

t=0:(1/Fs):L; % base temporale
tc=0:(1/Fc):L; % base temporale al control rate 

%==============================================================%

% genera segnali di controllo
f1=envgen([0,5,10,15,20],[200,200,200,200,200]);
f2=envgen([0,1,5,10,15,20],[200,200,205,220,270,300]);
a=envgen([0,5,10,15,20],[1,1,1,1,1]);

% genera segnali audio 
s=sinosc(0,a,f1,0)+sinosc(0,a,f2,0);

pause

% plot dei risultati
figure(1)
subplot(2,1,1)
plot([1:length(a)]*SpF,a*max(f2)/max(a),[1:length(a)]*SpF,f2,':');
subplot(2,1,2)
plot(s)
