%main

%=============================================================% 

global Fs; 
Fs=22050 % sample rate
ControlW=0.01 % control window (in sec): 10 ms
global SpF;
SpF=round(Fs*ControlW) % samples per Frame 
Fc=Fs/SpF % control rate
%==============================================================%

% genera segnali di controllo
f1=envgen([0,20],[200,200]);
f2=envgen([0,1,5,10,15,20],[200,200,205,220,270,300]);
a=envgen([0,20],[1,1]);

% genera segnali audio 
s=sinosc(0,a,f1,0)+sinosc(0,a,f2,0);

pause

% plot dei risultati
figure(1)
subplot(2,1,1)
plot([0:20/(length(f2)-1):20],f2);
title('pitch of second tone (first tone: pitch=200 Hz)');
xlabel('sec')
ylabel('Hz')
subplot(2,1,2)
plot([0:20*20/(length(s)-1):20],s(1:20:length(s)))
axis([0 20 -3 3])
title('waveform with amplitude modulation (first order beats)')
xlabel('sec')
ylabel('lin. scale')
