%mainenv

%=============================================================% 

global Fs; 
Fs=22050 % sample rate
ControlW=0.01 % control window (in sec): 10 ms
global SpF;
SpF=round(Fs*ControlW) % samples per Frame 
Fc=Fs/SpF % control rate

%==============================================================%

% genera segnali di controllo
f=envgen([0,.2,1,2],[200,250,250,340],'cubic'); % curva di pitch 
f=f+max(f)*0.05*sin(2*pi*5*(SpF/Fs)*[0:length(f)-1]).*hanning(length(f))'; % curva di pitch con vibrato inviluppato
%f=envgen([0,.2,1,1.5,2],[200,250,250,350,200],'cubic');
a=envgen([0,.2,1,1.5,2],[0,1,.8,.5,0],'linear');

% genera segnali audio 
s=sinosc(0.5,a,f,0);

% plot dei risultati
figure(1)
h=plotrow([2 1]);
axes(h(1))
plot([0:2/(length(a)-1):2],a)
title('amplitude envelope')
xlabel('sec')
ylabel('linear scale')
axes(h(2))
plot([0:2/(length(f)-1):2],f)
title('pitch')
ylabel('Hz')
xlabel('sec')
axes(h(3))
plot([0:2*50/(length(s)-1):2],s(1:50:length(s)))
title('waveform')
ylabel('linear scale')
xlabel('sec')

