%mainvocali

global Fs; 
Fs=22050 % sample rate
ControlW=0.01 % control window (in sec): 10 ms
global SpF;
SpF=round(Fs*ControlW) % samples per Frame 
Fc=Fs/SpF % control rate

% genera segnali di controllo
f=envgen([0,.2,1.8,2],[200,250,250,200],'linear'); % curva di pitch
f=f+max(f)*0.05*sin(2*pi*5*(SpF/Fs)*[0:length(f)-1]).*hanning(length(f))'; % curva di pitch con vibrato inviluppato
amp=envgen([0,.2,1,1.8,2],[0,1,.8,1,0],'linear');

%genera sorgente impulsiva
s=buzz(0,amp,f);

%inviluppo spettrale /i/
[b,a]=baIIR2([300 2400 3000],[200 200 200]);
si=filter(b(1,:),a(1,:),s)+filter(b(2,:),a(2,:),s)+filter(b(3,:),a(3,:),s);

%inviluppo spettrale /a/
[b,a]=baIIR2([700 1200 2500],[200 300 500]);
sa=filter(b(1,:),a(1,:),s)+filter(b(2,:),a(2,:),s)+0.3*filter(b(3,:),a(3,:),s);

%inviluppo spettrale /o/
[b,a]=baIIR2([600 900 3000],[100 100 800]);
so=filter(b(1,:),a(1,:),s)+filter(b(2,:),a(2,:),s)+0.3*filter(b(3,:),a(3,:),s);

%inviluppo spettrale /u/
[b,a]=baIIR2([380 950],[100 100]);
su=filter(b(1,:),a(1,:),s)+filter(b(2,:),a(2,:),s);

%inviluppo spettrale /e/
[b,a]=baIIR2([570 1950 3000],[100 100 800]);
se=filter(b(1,:),a(1,:),s)+filter(b(2,:),a(2,:),s)+0.3*filter(b(3,:),a(3,:),s);

