% vuole s se, sa, si

global Fs

N=1024;

figure(1)
subplot(2,2,1)
f=envgen([0,2],[250,250],'linear'); % curva di pitch
%f=f+max(f)*0.05*sin(2*pi*5*(SpF/Fs)*[0:length(f)-1]).*hanning(length(f))'; % curva di pitch con vibrato inviluppato
amp=envgen([0,2],[1,1],'linear');

%genera sorgente impulsiva
s=buzz(0,amp,f);
S=(fft(s(10000:15000),N));
plot([0:(Fs/(N)):Fs/4-1],db(S(1:N/4)))
title('a) pulse signal (pitch=250 Hz)')
xlabel('Hz')

subplot(2,2,2)
[b,a]=baIIR2([300 2400 3000],[200 200 200]); %/i/
for (i=1:size(a,1))
 [H,w]=freqz(b(i,:),a(i,:));
 plot(Fs*w(1:length(w)/2)/(2*pi),db(H(1:length(w)/2)))
 ylabel('db')
 xlabel('Hz')
 hold on
end
title('b) II order cells configured for vowel /i/')

subplot(2,2,3)
[b,a]=baIIR2([300 2400 3000],[200 200 200]);
si=filter(b(1,:),a(1,:),s)+filter(b(2,:),a(2,:),s)+filter(b(3,:),a(3,:),s);
Si=(fft(si(10000:15000),N));
plot([0:(Fs/N):Fs/4-1],db(Si(1:N/4)))
title('c) pulse wave convolved by II order cells')
xlabel('Hz')
axis([0 6000 0 max(db(Si(1:N/4)))])

subplot(2,2,4)
f=envgen([0,.2,1.8,2],[100,100,100,100],'linear'); % curva di pitch
%f=f+max(f)*0.05*sin(2*pi*5*(SpF/Fs)*[0:length(f)-1]).*hanning(length(f))'; % curva di pitch con vibrato inviluppato
amp=envgen([0,2],[1,1],'linear');

%genera sorgente impulsiva
s=buzz(0,amp,f);
%inviluppo spettrale /i/
[b,a]=baIIR2([300 2400 3000],[200 200 200]);
si=filter(b(1,:),a(1,:),s)+filter(b(2,:),a(2,:),s)+filter(b(3,:),a(3,:),s);
Si=(fft(si(10000:15000),N));
plot([0:(Fs/N):Fs/4-1],db(Si(1:N/4)))
xlabel('Hz')
axis([0 6000 0 max(db(Si(1:N/4)))])
title('d) result when pulse waveform pitch=100 Hz)')






