function s = sinosc(t0,a,f,phi0);
% oscillatore sinusoidale
% a e f sono al control rate
% t0 istante iniziale in sec; 

global SpF; %samples per frame
global Fs; %sampling rate
Fc=Fs/SpF; %control rate 

nframes=length(a); %numero di frames
if (length(f)==1) f=f*ones(1,nframes); end
if (length(f)~=nframes)
   error('f and a must have equal length');
end

s=zeros(1,nframes*SpF);

lastfreq=f(1);
lastphase=0;
for (i=1:nframes)
   taux=1/Fs:(1/Fs):(SpF/Fs);
   phase=lastphase+lastfreq*2*pi.*taux+(1/SpF)*pi*(f(i)-lastfreq).*(taux.^2);
   s(((i-1)*SpF+1):i*SpF)=a(i).*sin(phase);   
   lastfreq=f(i);
   lastphase=phase(SpF);
end

s=[zeros(1,(t0*Fs-1)) s];
