Fs=22050; % frequenza di campionamento 

fc=700; %portante: 700 Hz
fm=100; %modulante: 100 Hz
I=1; %indice di modulazione 
t=0:(1/Fs):3-1/Fs; %asse temporale: 3 sec

s1=sin(2*pi*fc*t+I*sin(2*pi*fm*t));

%plot dello spettro
figure(1)
h=plotcol([1 1 1])
axes(h(1))
N=2048;
S=(fft(s1,N));
plot([0:(Fs/N):Fs/4-1],db(S(1:N/4)))
xlabel('Hz')
ylabel('db')
axis([0 2000 0 max(db(S(1:N/4)))])
title('fc=700 Hz, fm=100 Hz, I=1')

I=2; %indice di modulazione 
s2=sin(2*pi*fc*t+I*sin(2*pi*fm*t));

%plot dello spettro
axes(h(2))
N=2048;
S=(fft(s2,N));
plot([0:(Fs/N):Fs/4-1],db(S(1:N/4)))
xlabel('Hz')
ylabel('db')
axis([0 2000 0 max(db(S(1:N/4)))])
title('fc=700 Hz, fm=100 Hz, I=2')

I=3; %indice di modulazione 
s3=sin(2*pi*fc*t+I*sin(2*pi*fm*t));

%plot dello spettro
axes(h(3))
N=2048;
S=(fft(s3,N));
plot([0:(Fs/N):Fs/4-1],db(S(1:N/4)))
xlabel('Hz')
ylabel('db')
axis([0 2000 0 max(db(S(1:N/4)))])
title('fc=700 Hz, fm=100 Hz, I=3')




