Fs=22050; % frequenza di campionamento 

fc1=300; %portante 1: 300 Hz
fc2=1000; %portante 2: 1000 Hz
fc3=3000; %portante 3: 3000 Hz
I1=1;
I2=2;
I3=3;

fm=100; %modulante: 100 Hz
t=0:(1/Fs):3; %asse temporale: 3 sec

s=sin(2*pi*fc1*t+I1*sin(2*pi*fm*t))+sin(2*pi*fc2*t+I2*sin(2*pi*fm*t))+sin(2*pi*fc3*t+I3*sin(2*pi*fm*t));

%plot dello spettro
figure(1)
N=2048;
S=(fft(s,N));
plot([0:(Fs/N):Fs/4-1],db(S(1:N/4)))
xlabel('Hz')
ylabel('db')
axis([0 5000 0 max(db(S(1:N/4)))])
title('fc1=300 Hz, fc2=1000 Hz, fc3=3000 Hz, fm=100 Hz, I1=1, I2=2, I3=3')





