Fs=22050; % frequenza di campionamento 

%fc=1000; %portante 2: 1000 Hz
%fm1=100; %modulante 1: 100 Hz
%fm2=900; %modulante 2: 200 Hz
fc=700;
fm1=300
fm2=200

I1=1;
I2=1;

t=0:(1/Fs):3; %asse temporale: 3 sec

sa=sin(2*pi*fc*t+I1*sin(2*pi*fm1*t)+I2*sin(2*pi*fm2*t));

%plot dello spettro
figure(1)
subplot(1,2,1)
N=2048;
S=(fft(sa,N));
plot([0:(Fs/N):Fs/4-1],db(S(1:N/4)))
xlabel('Hz')
ylabel('db')
axis([0 5000 0 max(db(S(1:N/4)))])
title('fc1=700 Hz, fm1=300 Hz, fm2=200 Hz, I1=1, I2=1')

fc=700;
fm1=700;
fm2=2800;

I1=1;
I2=1;
sb=sin(2*pi*fc*t+I1*sin(2*pi*fm1*t)+I2*sin(2*pi*fm2*t));

%plot dello spettro
subplot(1,2,2)
N=2048;
S=(fft(sb,N));
plot([0:(Fs/N):Fs/4-1],db(S(1:N/4)))
xlabel('Hz')
ylabel('db')
axis([0 7000 0 max(db(S(1:N/4)))])
title('fc1=700 Hz, fm1=700 Hz, fm2=2800 Hz, I1=1, I2=1')

figure(2) %inarmonicit 

fc=700;
fm1=700+[5 20];
fm2=2800+[5 5];

I1=1;
I2=1;
s1=sin(2*pi*fc*t+I1*sin(2*pi*fm1(1)*t)+I2*sin(2*pi*fm2(1)*t));
s2=sin(2*pi*fc*t+I1*sin(2*pi*fm1(2)*t)+I2*sin(2*pi*fm2(2)*t));

%plot dello spettro
subplot(1,2,1)
N=2048;
S1=(fft(s1,N));
plot([0:(Fs/N):Fs/4-1],db(S1(1:N/4)))
xlabel('Hz')
ylabel('db')
axis([0 7000 0 max(db(S1(1:N/4)))])
title('fc1=700 Hz, fm1=705 Hz, fm2=2805 Hz')

%plot dello spettro
subplot(1,2,2)
N=2048;
S2=(fft(s2,N));
plot([0:(Fs/N):Fs/4-1],db(S2(1:N/4)))
xlabel('Hz')
ylabel('db')
axis([0 7000 0 max(db(S2(1:N/4)))])
title('fc1=700 Hz, fm1=720 Hz, fm2=2805 Hz')