package com.example.elena.cameraintent;

import android.app.Activity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.View.OnClickListener;
import android.widget.Button;
import android.widget.ImageView;
import android.content.Intent;
import android.net.Uri;
import android.provider.MediaStore;
import android.os.Environment;
import java.io.File;
import android.util.Log;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

import android.widget.Toast;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;


public class MainActivity extends Activity {

    private static final String TAG = "CallCamera";
    private static final int CAPTURE_IMAGE_ACTIVITY_REQ = 0;

    Uri fileUri = null;
    ImageView photoImage = null;

    private File getOutputPhotoFile()
    {
        File directory = new File(Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_PICTURES),getPackageName());
        if (!directory.exists())
        {
            if (!directory.mkdirs())
            {
                Log.e(TAG,"Failed to create storage directory");
                return null;
            }
        }
        String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.ITALY).format(new Date());
        return new File (directory.getPath()+ File.separator + "IMG_" + timeStamp + ".jpg");
    }

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        photoImage = (ImageView)findViewById(R.id.photoImage);

        Button buttonCamera = (Button)findViewById(R.id.buttonCamera);
        buttonCamera.setOnClickListener(
                new OnClickListener() {

                    @Override
                    public void onClick(View v) {

                        Intent i = new Intent (MediaStore.ACTION_IMAGE_CAPTURE);
                        fileUri = Uri.fromFile(getOutputPhotoFile());
                        i.putExtra(MediaStore.EXTRA_OUTPUT,fileUri);

                        startActivityForResult(i, CAPTURE_IMAGE_ACTIVITY_REQ);
                    }
                }
        );
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data)
    {
       if (requestCode == CAPTURE_IMAGE_ACTIVITY_REQ)
       {
           if(resultCode == RESULT_OK)
           {
               //Image captured and saved to fileUri specified in the intent
               Uri photoUri = null;
               if (data == null)
               {
                   //A known bug here!
                   Toast.makeText(this,"Image saved successfully",Toast.LENGTH_LONG).show();
                   photoUri=fileUri;
               }
               else
               {
                   photoUri = data.getData();
                   Toast.makeText(this,"Image saved succesfully in: "+ data.getData(),Toast.LENGTH_LONG).show();
               }
               showPhoto(photoUri.getPath());
           }
           else if (resultCode == RESULT_CANCELED)
           {
               //User cancelled the image capture
               Toast.makeText(this,"Cancelled",Toast.LENGTH_SHORT).show();
           }
           else
           {
               //Image capture failed, advise uer
               Toast.makeText(this,"Callout for image capture failed!",Toast.LENGTH_LONG).show();
           }
       }
    }

    private void showPhoto(String photoUri)
    {
        /*Once your activity receives a successful result,
         * the captured image is aviable in the specified location
         * for your application to access. Here is a method to display the photo saved
         */
        File imageFile = new File (photoUri);
        if (imageFile.exists())
        {
            Bitmap bitmap = BitmapFactory.decodeFile(imageFile.getAbsolutePath());
            BitmapDrawable drawable = new BitmapDrawable(this.getResources(),bitmap);
            photoImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
            photoImage.setImageDrawable(drawable);
        }
    }


    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.menu_main, menu);
        return true;
    }

    @Override
    public boolean onOptionsItemSelected(MenuItem item) {
        // Handle action bar item clicks here. The action bar will
        // automatically handle clicks on the Home/Up button, so long
        // as you specify a parent activity in AndroidManifest.xml.
        int id = item.getItemId();

        //noinspection SimplifiableIfStatement
        if (id == R.id.action_settings) {
            return true;
        }

        return super.onOptionsItemSelected(item);
    }
}
