/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.concurrent;

import biz.papercut.pcng.util.concurrent.PriorityCallable;
import biz.papercut.pcng.util.concurrent.PriorityRunnable;
import java.util.concurrent.Callable;

public final class Runnables {
    private Runnables() {
    }

    public static Thread startInDaemonThread(String name, Runnable runnable) {
        Thread thread = new Thread(runnable, name);
        thread.setDaemon(true);
        thread.start();
        return thread;
    }

    public static Thread startInDaemonThread(String name, int priority, Runnable runnable) {
        Thread thread = new Thread(runnable, name);
        thread.setDaemon(true);
        thread.setPriority(priority);
        thread.start();
        return thread;
    }

    public static Thread startInDaemonThread(String groupName, String name, int priority, Runnable runnable) {
        ThreadGroup group = new ThreadGroup(groupName);
        group.setDaemon(true);
        Thread thread = new Thread(group, runnable, name);
        thread.setDaemon(true);
        thread.setPriority(priority);
        thread.start();
        return thread;
    }

    public static PriorityRunnable priorityDecorator(final Runnable delegate, final int priority) {
        return new PriorityRunnable(){

            @Override
            public int getPriority() {
                return priority;
            }

            @Override
            public void run() {
                delegate.run();
            }
        };
    }

    public static <T> PriorityCallable<T> priorityDecorator(final Callable<T> delegate, final int priority) {
        return new PriorityCallable<T>(){

            @Override
            public int getPriority() {
                return priority;
            }

            @Override
            public T call() throws Exception {
                return delegate.call();
            }
        };
    }
}

