#!/bin/bash

no_root () {
	echo
	echo " Dovete eseguire lo script come root"
	echo " o con privilegi di root ( sudo )"
	echo
	echo " This script must be executed as root"
	echo " or with root privileges ( sudo )"
	echo
	exit -1
}

[ "$USER" != "root" ] && no_root

cp -rf pc-client/ /usr/local/ 
[ -d /etc/xdg/autostart ] && cp pc-client.desktop /etc/xdg/autostart/
[ -d /usr/share/applications ] && cp pc-client.desktop /usr/share/applications
[ -d /usr/share/menu ] && cp pc-client.menu /usr/share/menu/pc-client
[ -x /usr/bin/update-menus ] && /usr/bin/update-menus
[ -x /usr/bin/update-desktop-database ] && [ -d /usr/share/applications ] /usr/bin/update-desktop-database
/usr/sbin/lpadmin -p papercut -v ipp://print.dei.unipd.it/printers/print -E -P ./print.ppd -D "PaperCut Kyocera DEI" -L "DEI"
cat <<END_MESSAGE

:::::::::::::::::ITALIANO::::::::::::::::::::::
La stampante 'papercut' e' stata installata sul
computer e configurata con le seguenti opzioni
abilitate di default:

    - bianco e nero

    - fronte retro (lato lungo)

Per usarla di default da linea di comando potete
dare (da utente non privilegiato) il comando

lpadmin -d papercut

Si ricorda che per stampare e' necessario sia 
attivo il client PaperCut.
:::::::::::::::::::::::::::::::::::::::::::::::

:::::::::::::::::ENGLISH:::::::::::::::::::::::
'papercut' printer has been installed and 
configured with the following defaults:

    - black and white printing

    - duplex (long edge)

To use it via command-line please use (as your
normal user)

lpadmin -d papercut

Please remember that PaperCut client must be
running to allow printing.
:::::::::::::::::::::::::::::::::::::::::::::::

END_MESSAGE
