/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.AuthHandler;
import biz.papercut.pcng.client.uit.ClientConfigFile;
import biz.papercut.pcng.client.uit.ClientController;
import biz.papercut.pcng.client.uit.MSWindowsUtils;
import biz.papercut.pcng.client.uit.MacUtils;
import biz.papercut.pcng.client.uit.Messages;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClient;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.UserClientUtils;
import biz.papercut.pcng.common.ClientGlobalConfigFromServer;
import biz.papercut.pcng.util.ApplicationException;
import biz.papercut.pcng.util.ApplicationInfo;
import biz.papercut.pcng.util.BrowserLinkUtils;
import biz.papercut.pcng.util.swing.BrowserLinkLabel;
import biz.papercut.pcng.util.swing.DialogUtils;
import biz.papercut.pcng.util.swing.FadeImage;
import biz.papercut.pcng.util.swing.SwingUtils;
import biz.papercut.pcng.util.swing.SwingWorker;
import com.google.common.util.concurrent.Uninterruptibles;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserClientFrame
extends JFrame
implements ClientController.BalanceUpdateListener,
ClientController.MessageListener {
    private static final Logger logger = LoggerFactory.getLogger(UserClientFrame.class);
    private static final int DEFAULT_CREDIT_LABEL_SIZE = 28;
    private static final int SMALL_CREDIT_LABEL_SIZE = 18;
    private static final float WINDOW_IN_FOCUS_ALPHA = 0.9f;
    private static final float WINDOW_OUT_FOCUS_ALPHA = 0.8f;
    private static final Color DEFAULT_TEXT_COLOR;
    private static final Color DEFAULT_LINK_COLOR;
    private static final Color DEFAULT_LINK_HOVER_COLOR;
    private static final Color DEFAULT_ADDITIONAL_LINK_COLOR;
    private static final Color DEFAULT_NEGATIVE_BALANCE_COLOR;
    private static final float DEFAULT_LOGO_ALPHA = 0.8f;
    private static final String REFRESH_ICON = "images/client-refresh.png";
    public static final String CLIENT_LOGO_STANDARD = "images/client-icon.png";
    private ServerConnection _serverConnection;
    private boolean _checkingBalance;
    private boolean _initialisationComplete;
    UserClientConfig _config;
    private boolean _popupDialogIsDisplayed;
    private JComponent _logoImage;
    private JLabel _creditLabel;
    private final ReentrantLock handlingClientActionLock = new ReentrantLock();
    private BrowserLinkLabel _userPageLink;
    private JPopupMenu _popupMenu;
    private TrayIcon _trayIcon;
    @Nullable
    private String _lastToolTipCreditText;

    <T> T withClientActionLock(Callable<T> action) throws Exception {
        try {
            this.handlingClientActionLock.lock();
            T t = action.call();
            return t;
        }
        finally {
            this.handlingClientActionLock.unlock();
        }
    }

    WindowListener getWindowListener() {
        return new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                if (UserClientFrame.this.hasTaskTray()) {
                    UserClientFrame.this.setState(1);
                    UserClientFrame.this.setVisible(false);
                } else {
                    UserClientFrame.this.setState(1);
                }
            }
        };
    }

    void preConnectionInit(UserClientConfig config) {
        logger.debug("Pre-connect initialization");
        this.setIconImage(this.createImageIcon(CLIENT_LOGO_STANDARD).getImage());
        this.buildMenus();
        if (!config.isDisableTaskTray()) {
            this.setupTaskTray();
        }
        this.getContentPane().addMouseListener(new PopupListener());
        this._creditLabel = new JLabel();
        this._creditLabel.addMouseListener(new PopupListener());
        logger.debug("Setting Swing layout");
        this.getContentPane().setLayout(null);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.getWindowListener());
        this.addWindowKeyEvents();
        this.setCursor(new Cursor(0));
        this.setResizable(false);
        JLabel refreshImage = new JLabel();
        refreshImage.setIcon(this.createRefreshImageIcon());
        refreshImage.setToolTipText(UserClientFrame.getMessage("refresh-balance"));
        refreshImage.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                UserClientFrame.this.refreshImageMouseClicked();
            }
        });
        this.getContentPane().add(refreshImage);
        this.scaleRefreshImageIcon(refreshImage);
        logger.debug("Pre-connect initialization complete");
    }

    void removeAllComponents() {
        this.getContentPane().removeAll();
        this.removeTaskTray();
        this.revalidate();
        this.repaint();
    }

    public ImageIcon createRefreshImageIcon() {
        return this.createImageIcon(REFRESH_ICON);
    }

    public void scaleRefreshImageIcon(JLabel refreshImage) {
        refreshImage.setBounds(195, 5, 20, 20);
    }

    void addWindowKeyEvents() {
    }

    void completeInitialisation(ServerConnection connection, UserClientConfig config) {
        ClientGlobalConfigFromServer serverConf;
        logger.debug("Completing initialisation");
        this._config = config;
        this._serverConnection = connection;
        this.setWindowTitle();
        if (this._config.getBackgroundColor() >= 0) {
            this.getContentPane().setBackground(new Color(this._config.getBackgroundColor()));
        }
        Color textColor = DEFAULT_TEXT_COLOR;
        if (this._config.getTextColor() >= 0) {
            textColor = new Color(this._config.getTextColor());
        }
        Color linkColor = DEFAULT_LINK_COLOR;
        Color linkHoverColor = DEFAULT_LINK_HOVER_COLOR;
        if (this._config.getLinkColor() >= 0) {
            linkColor = new Color(this._config.getLinkColor());
        }
        if (this._config.getLinkHoverColor() >= 0) {
            linkHoverColor = new Color(this._config.getLinkHoverColor());
        }
        Color additionalLinkColor = DEFAULT_ADDITIONAL_LINK_COLOR;
        if (this._config.getAdditionalLinkColor() >= 0) {
            additionalLinkColor = new Color(this._config.getAdditionalLinkColor());
        }
        if ((serverConf = this._config.getServerGlobalConfig()).isShowLink() && StringUtils.isNotBlank((String)serverConf.getLinkURL()) && StringUtils.isNotBlank((String)serverConf.getLinkText())) {
            BrowserLinkLabel linkLabel = new BrowserLinkLabel(serverConf.getLinkText(), serverConf.getLinkURL());
            linkLabel.setForeground(additionalLinkColor);
            linkLabel.setHighlightedColor(additionalLinkColor);
            linkLabel.setHorizontalAlignment(4);
            this.getContentPane().add((Component)linkLabel);
            linkLabel.setBounds(70, 5, 120, 20);
        }
        if (serverConf.isShowDetailsLink() && StringUtils.isNotBlank((String)this._config.getUserPageURL())) {
            this._userPageLink = new BrowserLinkLabel(UserClientFrame.getMessage("user-details"));
            this.setUserDetailsURLLink();
            this._userPageLink.setForeground(linkColor);
            this._userPageLink.setHighlightedColor(linkHoverColor);
            this._userPageLink.setHorizontalAlignment(4);
            this.getContentPane().add((Component)this._userPageLink);
            this._userPageLink.setBounds(90, 57, 120, 15);
        }
        this._creditLabel.setFont(new Font(this._creditLabel.getFont().getName(), 0, 28));
        this._creditLabel.setHorizontalAlignment(2);
        this._creditLabel.setText("");
        this.getContentPane().add(this._creditLabel);
        this._creditLabel.setForeground(textColor);
        this._creditLabel.setBounds(75, 15, 140, 50);
        this.applyLogoIcon(config.getServerUrl(), serverConf.getCustomLogoUrl());
        if (StringUtils.isNotBlank((String)serverConf.getDisplayBackgroundColor())) {
            this._config.setBackgroundColor(StringUtils.stripStart((String)serverConf.getDisplayBackgroundColor(), (String)"#"));
            this.getContentPane().setBackground(new Color(this._config.getBackgroundColor()));
        }
        if (this._config.getBackgroundColor() < 0) {
            JLabel backgroundImage = new JLabel();
            backgroundImage.setIcon(this.createImageIcon("images/client-background.png"));
            this.getContentPane().add(backgroundImage);
            backgroundImage.setBounds(0, 0, 224, 99);
        }
        this.setWindowPositionFromConfig(this._config);
        this.doBalanceRefresh();
        this.buildMenus();
        if (!this._config.isDisableGUIEffects()) {
            this.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    if (UserClientFrame.this.isVisible()) {
                        SwingUtils.setWindowAlpha((Window)UserClientFrame.this, (float)0.9f);
                    }
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    if (UserClientFrame.this.isVisible()) {
                        SwingUtils.setWindowAlpha((Window)UserClientFrame.this, (float)0.8f);
                    }
                }
            });
        }
        if (this._config.isStartMinimised() || this._config.getServerGlobalConfig().isStartMinimized() || !this._config.getServerUserConfig().isShowBalance()) {
            if (this.hasTaskTray()) {
                this.setVisible(false);
            } else {
                int state = this.getExtendedState();
                this.setVisible(true);
                this.setExtendedState(state |= 1);
            }
        } else {
            this.setVisible(true);
            this.toFront();
        }
        if (this._logoImage instanceof FadeImage) {
            FadeImage fadeImage = (FadeImage)this._logoImage;
            if (this._config.isDisableGUIEffects()) {
                fadeImage.setAlpha(0.8f);
            } else {
                fadeImage.fadeToAlpha(0.8f, 750L);
            }
        }
        DialogUtils.forceRepaintAfterOpened((Window)this);
        this._initialisationComplete = true;
    }

    protected URL getResourceLogo(String logoURLStr) {
        URL logoURL = this.getClass().getResource(logoURLStr);
        if (logoURL == null) {
            throw new ApplicationException("Unable to find logo file: " + logoURLStr);
        }
        return logoURL;
    }

    private void applyLogoIcon(String serverUrl, String customLogoUrl) {
        URL logoURL = null;
        boolean isPaperCutLogo = true;
        if (StringUtils.isNotBlank((String)customLogoUrl)) {
            UserClientUtils.setCustomIconImage(serverUrl + customLogoUrl);
        } else {
            UserClientUtils.setCustomIconImage(null);
        }
        URL customLogo = UserClientUtils.getCustomIconImage();
        if (customLogo != null) {
            logger.debug("Using custom icon image: " + customLogo);
            logoURL = customLogo;
            isPaperCutLogo = false;
        } else {
            logoURL = this.getResourceLogo(CLIENT_LOGO_STANDARD);
        }
        this._logoImage = this.createLogoImage(logoURL, isPaperCutLogo);
        this.getContentPane().add(this._logoImage);
        this.setLogoBounds(this._logoImage, isPaperCutLogo);
    }

    public JComponent createLogoImage(URL logoURL, boolean isPaperCutLogo) {
        if (SystemUtils.IS_JAVA_1_4) {
            return new JLabel(new ImageIcon(logoURL));
        }
        return new FadeImage(logoURL, 0.0f);
    }

    public void setLogoBounds(JComponent logoImage, boolean isPaperCutLogo) {
        logoImage.setBounds(5, 5, 64, 64);
    }

    private void setWindowPositionFromConfig(UserClientConfig config) {
        String[] coords;
        Dimension dimensions = UserClientFrame.configureDimensions(224, 105);
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        String windowPos = StringUtils.trimToNull((String)config.getWindowPosition());
        if (windowPos == null) {
            windowPos = "top-right";
        }
        int xIn = 0;
        int yIn = 0;
        boolean usingCoords = false;
        if (windowPos.startsWith("XY") && windowPos.indexOf(44) > 0 && (coords = windowPos.split("\\s*,\\s*")).length > 0) {
            try {
                xIn = Integer.parseInt(coords[0].substring(2));
                yIn = Integer.parseInt(coords[1]);
                usingCoords = true;
            }
            catch (NumberFormatException nfe) {
                xIn = 0;
                yIn = 0;
            }
        }
        if (!usingCoords) {
            if (windowPos.equalsIgnoreCase("top-left")) {
                xIn = 40;
                yIn = 40;
            } else if (windowPos.equalsIgnoreCase("top-right")) {
                xIn = -40;
                yIn = 40;
            } else if (windowPos.equalsIgnoreCase("bottom-left")) {
                xIn = 40;
                yIn = -40;
            } else if (windowPos.equalsIgnoreCase("bottom-right")) {
                xIn = -40;
                yIn = -40;
            } else {
                xIn = -40;
                yIn = 40;
            }
        }
        int x = xIn > 0 ? xIn : screenSize.width - dimensions.width - -xIn;
        int y = yIn > 0 ? yIn : screenSize.height - dimensions.height - -yIn;
        this.setBounds(x, y, dimensions.width, dimensions.height);
    }

    private static Dimension configureDimensions(int width, int height) {
        Dimension dimensions = new Dimension(width, height);
        try {
            if (SystemUtils.IS_OS_WINDOWS && Toolkit.getDefaultToolkit().getScreenResolution() >= 120) {
                dimensions.height += 12;
            } else if (MSWindowsUtils.isWindows8OrHigher() && SystemUtils.isJavaVersionAtLeast((int)9) && UserClientFrame.launchedFromJava()) {
                logger.warn("Applying HiDPI scaling workaround on Windows 8+");
                dimensions.height += 12;
                dimensions.width += 12;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dimensions;
    }

    private static boolean launchedFromJava() {
        return ProcessHandle.current().info().command().map(c -> StringUtils.endsWithAny((String)c, (String[])new String[]{"java.exe", "java"})).orElse(false);
    }

    void updateDisplay() {
        SwingUtilities.invokeLater(() -> {
            this.setWindowTitle();
            this.setUserDetailsURLLink();
            this.doBalanceRefresh();
            this.buildMenus();
        });
    }

    private void setWindowTitle() {
        if (StringUtils.isBlank((String)this._config.getWindowTitle())) {
            this.setTitle(UserClientFrame.format("balance-for", this._config.getDisplayUserName()));
        } else {
            this.setTitle(MessageFormat.format(this._config.getWindowTitle(), this._config.getDisplayUserName()));
        }
    }

    private void setUserDetailsURLLink() {
        if (this._userPageLink == null) {
            return;
        }
        String pageURL = this.getUserDetailsURLLink();
        this._userPageLink.setLinkURL(pageURL);
    }

    String getUserDetailsURLLink() {
        Object pageURL = this._config.getUserPageURL();
        String usernameEncoded = URLEncoder.encode(this._config.getDisplayUserName(), StandardCharsets.UTF_8);
        pageURL = (String)pageURL + "?username=" + usernameEncoded;
        return pageURL;
    }

    void setupTaskTray() {
        if (!SystemUtils.IS_OS_WINDOWS) {
            logger.debug("Not on Windows, do not try to initialise the task tray.");
            return;
        }
        try {
            logger.debug("Setting up task tray");
            ImageIcon image = this.createImageIcon(CLIENT_LOGO_STANDARD);
            this._trayIcon = new TrayIcon(image.getImage());
            this._trayIcon.setImageAutoSize(true);
            this._trayIcon.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (e.isPopupTrigger()) {
                        UserClientFrame.this._popupMenu.setLocation(e.getX(), e.getY());
                        UserClientFrame.this._popupMenu.setInvoker(UserClientFrame.this._popupMenu);
                        UserClientFrame.this._popupMenu.setVisible(true);
                    }
                }
            });
            this._trayIcon.setToolTip(UserClientFrame.getMessage("connecting"));
            this._trayIcon.addActionListener(e -> {
                if (this._config != null && this._config.getServerUserConfig().isShowBalance()) {
                    this.makeVisible();
                }
            });
            SystemTray tray = SystemTray.getSystemTray();
            tray.add(this._trayIcon);
        }
        catch (Throwable t) {
            logger.error("Error setting up task tray", t);
            this._trayIcon = null;
        }
    }

    void buildMenus() {
        if (logger.isDebugEnabled()) {
            logger.debug("Building popup menu. Config: " + this._config);
        }
        if (this.getPopupMenu() == null) {
            this._popupMenu = new JPopupMenu("Tray Icon Menu");
        }
        this.getPopupMenu().removeAll();
        JMenuItem openItem = new JMenuItem(UserClientFrame.getMessage("open"));
        openItem.addActionListener(evt -> this.makeVisible());
        openItem.setOpaque(true);
        if (this._config != null && this._config.getServerUserConfig().isShowBalance()) {
            logger.debug("Show balance, add open item");
            this.getPopupMenu().add(openItem);
        }
        if (this._config != null) {
            if (this._config.isCurrentlyAuthenticated()) {
                logger.debug("Currently authenticated, add logout menu");
                JMenuItem logout = new JMenuItem(UserClientFrame.getMessage("logout"));
                logout.addActionListener(evt -> this.doLogout());
                logout.setOpaque(true);
                this.getPopupMenu().add(logout);
            }
            if (this._config.getServerUserConfig().isUnauthenticatedUser()) {
                logger.debug("Unauthenticated, add login as menu");
                JMenuItem login = new JMenuItem(UserClientFrame.getMessage("login-as"));
                login.addActionListener(evt -> {
                    ClientConfigFile.deleteUserAuthCookie();
                    this.doLogin();
                });
                login.setOpaque(true);
                this.getPopupMenu().add(login);
            }
            if (this._config.getServerGlobalConfig().isShowDetailsLink() && StringUtils.isNotBlank((String)this._config.getUserPageURL())) {
                JMenuItem userDetailsItem = new JMenuItem(UserClientFrame.getMessage("user-details"));
                userDetailsItem.addActionListener(evt -> BrowserLinkUtils.openBrowser((String)this.getUserDetailsURLLink()));
                userDetailsItem.setOpaque(true);
                this.getPopupMenu().add(userDetailsItem);
            }
            if (this._config.getServerGlobalConfig().isShowLink() && StringUtils.isNotBlank((String)this._config.getServerGlobalConfig().getLinkURL()) && StringUtils.isNotBlank((String)this._config.getServerGlobalConfig().getLinkText())) {
                JMenuItem linkItem = new JMenuItem(this._config.getServerGlobalConfig().getLinkText());
                linkItem.addActionListener(evt -> BrowserLinkUtils.openBrowser((String)this._config.getServerGlobalConfig().getLinkURL()));
                linkItem.setOpaque(true);
                this.getPopupMenu().add(linkItem);
            }
        }
        if (this.getPopupMenu().getComponents().length > 0) {
            this.getPopupMenu().addSeparator();
        }
        JMenuItem exitItem = new JMenuItem(UserClientFrame.getMessage("exit"));
        exitItem.addActionListener(evt -> {
            logger.debug("User select 'Exit'");
            this.exitIfAllowed();
        });
        exitItem.setOpaque(true);
        this.getPopupMenu().add(exitItem);
    }

    void doLogout() {
        logger.debug("clearing authentication");
        this._serverConnection.clearAuthentication();
        this._config.logoutUser();
        ClientConfigFile.deleteUserAuthCookie();
        this.updateDisplay();
    }

    void doLogin() {
        AuthHandler handler = new AuthHandler(this, this._serverConnection, this._config);
        handler.doAuthRequest();
    }

    void makeVisible() {
        if (this._initialisationComplete && !this._popupDialogIsDisplayed) {
            if (this._logoImage instanceof FadeImage && !this.isVisible()) {
                FadeImage fadeImage = (FadeImage)this._logoImage;
                if (this._config.isDisableGUIEffects()) {
                    fadeImage.setAlpha(0.8f);
                } else {
                    fadeImage.setAlpha(0.0f);
                    fadeImage.fadeToAlpha(0.8f, 750L);
                }
            }
            this.setState(0);
            this.setVisible(true);
            this.toFront();
        }
    }

    boolean hasTaskTray() {
        return this._trayIcon != null;
    }

    public void setTaskTrayToolTip(String text) {
        if (this._trayIcon != null) {
            this._trayIcon.setToolTip(text);
        }
    }

    @Override
    public void newMessages(List<String> messages, UserClientConfig config) {
        this.invokeAndWait(() -> this.displayMessages(messages, config));
    }

    @Override
    public void newBalance(String balance) {
        this.invokeAndWait(() -> this.setFormattedCreditText(balance));
    }

    private void invokeAndWait(Runnable doRun) {
        try {
            SwingUtilities.invokeAndWait(doRun);
        }
        catch (Exception e) {
            logger.error("Error occurred: " + e.getMessage(), (Throwable)e);
        }
    }

    private void displayMessages(List<String> msgs, UserClientConfig config) {
        for (String msg : msgs) {
            if (MSWindowsUtils.isWindows8OrHigher() && !config.isDisableToastNotifications()) {
                MSWindowsUtils.sendWindows8Message(msg);
                continue;
            }
            if (this.hasTaskTray() && !SystemUtils.IS_OS_MAC_OSX && !config.isDisableTaskTrayBalloonTips()) {
                logger.debug("Display message using task tray.");
                this.displayTrayMessage(msg);
                continue;
            }
            if (SystemUtils.IS_OS_MAC_OSX && MacUtils.growlNotify(msg)) {
                logger.debug("Message successfully displayed using growl.");
                continue;
            }
            logger.debug("Display message via popup dialog");
            this.setAlwaysOnTop(true);
            DialogUtils.showInformationMessageDialog((Component)this, (String)UserClientFrame.getMessage("message"), (String)msg);
            this.setAlwaysOnTop(false);
            logger.debug("Display message via popup dialog completed");
        }
    }

    private void displayTrayMessage(String msg) {
        this._trayIcon.displayMessage(UserClientFrame.getMessage("message"), msg, TrayIcon.MessageType.INFO);
    }

    private void refreshImageMouseClicked() {
        this.doBalanceRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doBalanceRefresh() {
        if (!this._config.getServerUserConfig().isShowBalance()) {
            this.setFormattedCreditText("");
            return;
        }
        UserClientFrame userClientFrame = this;
        synchronized (userClientFrame) {
            if (this._checkingBalance) {
                return;
            }
            this._checkingBalance = true;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        SwingWorker<Object> worker = new SwingWorker<Object>(){
            private String _creditValue;
            private boolean _errorOccurred;

            public Object construct() {
                try {
                    this._creditValue = UserClientFrame.this.getServerConnection().getUserBalance(UserClientFrame.this._config.getDisplayUserName());
                    if (StringUtils.isBlank((String)this._creditValue)) {
                        this._errorOccurred = true;
                    }
                }
                catch (Exception e) {
                    this._errorOccurred = true;
                    logger.error("Error getting balance", (Throwable)e);
                }
                return null;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void finished() {
                try {
                    UserClientFrame.this.setCursor(Cursor.getPredefinedCursor(0));
                    if (!this._errorOccurred && this._creditValue != null) {
                        UserClientFrame.this.setFormattedCreditText(this._creditValue);
                        this._creditValue = null;
                    }
                }
                finally {
                    UserClientFrame userClientFrame = UserClientFrame.this;
                    synchronized (userClientFrame) {
                        UserClientFrame.this._checkingBalance = false;
                    }
                }
            }
        };
        worker.start();
    }

    private void setTextColor(String creditValue) {
        boolean isNegativeValue;
        boolean bl = isNegativeValue = creditValue.contains("-") || creditValue.contains("(") && creditValue.contains(")");
        if (isNegativeValue) {
            Color negativeBalanceColor = DEFAULT_NEGATIVE_BALANCE_COLOR;
            if (this._config.getNegativeBalanceColor() >= 0) {
                negativeBalanceColor = new Color(this._config.getNegativeBalanceColor());
            }
            this._creditLabel.setForeground(negativeBalanceColor);
        } else {
            Color textColor = DEFAULT_TEXT_COLOR;
            if (this._config.getTextColor() >= 0) {
                textColor = new Color(this._config.getTextColor());
            }
            this._creditLabel.setForeground(textColor);
        }
    }

    private void setFormattedCreditText(String creditValue) {
        if (this._config.getServerUserConfig().isShowBalance()) {
            String currentValue = this._creditLabel.getText();
            Font currentFont = this._creditLabel.getFont();
            logger.debug("Balance label font: " + currentFont.getFontName());
            this._creditLabel.setHorizontalAlignment(creditValue.length() <= 3 ? 0 : 2);
            DialogUtils.setTextHandlingFontDisplayProblems((JLabel)this._creditLabel, (String)creditValue);
            this._creditLabel.setText(creditValue);
            this.setTextColor(creditValue);
            Font standardFont = new Font(this._creditLabel.getFont().getName(), 0, 28);
            FontMetrics standardMetrics = this._creditLabel.getFontMetrics(standardFont);
            if (standardMetrics.stringWidth(creditValue) > this._creditLabel.getWidth()) {
                if (this._creditLabel.getFont().getSize() == 28) {
                    this._creditLabel.setFont(new Font(this._creditLabel.getFont().getName(), 0, 18));
                }
            } else if (this._creditLabel.getFont().getSize() == 18) {
                this._creditLabel.setFont(new Font(this._creditLabel.getFont().getName(), 0, 28));
            }
            this._creditLabel.setToolTipText(creditValue);
            this.animateCreditChange(currentValue, creditValue);
        } else {
            logger.debug("User is not configured to display balance, so display '-----'. User may not be allowed to charge to a personal balance or balance display is disabled.");
            this._creditLabel.setText("-----");
            this._creditLabel.setHorizontalAlignment(0);
        }
        String toolTipText = ApplicationInfo.getInstance().getApplicationName() + "\n" + this._config.getDisplayUserName();
        if (this._config.getServerUserConfig().isShowBalance()) {
            toolTipText = toolTipText + ": " + creditValue;
        }
        this._lastToolTipCreditText = toolTipText;
        this.setTaskTrayToolTip(toolTipText);
    }

    void restoreLastToolTipCreditText() {
        if (this._lastToolTipCreditText != null) {
            this.setTaskTrayToolTip(this._lastToolTipCreditText);
        } else {
            this.doBalanceRefresh();
        }
    }

    private void animateCreditChange(String from, String to) {
        double fromNumber = 0.0;
        double toNumber = 0.0;
        String toNumberPortion = "";
        try {
            Pattern p = Pattern.compile("[\\-\\d,\\s]+[\\.]\\d\\d");
            Matcher fromMatcher = p.matcher(StringUtils.trimToEmpty((String)from));
            Matcher toMatcher = p.matcher(StringUtils.trimToEmpty((String)to));
            if (toMatcher.find()) {
                toNumberPortion = toMatcher.group();
                NumberFormat nf = NumberFormat.getInstance();
                toNumber = nf.parse(toMatcher.group()).doubleValue();
                if (fromMatcher.find()) {
                    fromNumber = nf.parse(fromMatcher.group()).doubleValue();
                }
            }
        }
        catch (Exception p) {
            // empty catch block
        }
        if (!this._config.isDisableGUIEffects() && StringUtils.isNotBlank((String)toNumberPortion) && Math.abs(toNumber - fromNumber) > 0.01) {
            double toNumberFinal = toNumber;
            double fromNumberFinal = fromNumber;
            String toStringFinal = to;
            String toNumberPortionFinal = toNumberPortion;
            Thread t = new Thread(() -> {
                try {
                    logger.debug("Animating balance change from: " + fromNumberFinal + " to " + toNumberFinal);
                    NumberFormat currencyFormat = NumberFormat.getInstance();
                    currencyFormat.setMaximumFractionDigits(2);
                    currencyFormat.setMinimumFractionDigits(2);
                    int steps = 10;
                    int maxDelay = 150;
                    int minDelay = 50;
                    for (int i = 0; i < 10; ++i) {
                        double value = (toNumberFinal - fromNumberFinal) * (double)i / 10.0 + fromNumberFinal;
                        if (Math.abs(toNumberFinal - fromNumberFinal) > 10.0) {
                            value = Math.round(value);
                        }
                        String valueFormatted = currencyFormat.format(value);
                        String output = toStringFinal.replace(toNumberPortionFinal, valueFormatted);
                        this.updateCreditLabelOnEventThread(output);
                        int delay = -100 * i / 10 + 150;
                        Thread.sleep(delay);
                    }
                }
                catch (InterruptedException currencyFormat) {
                }
                catch (Exception e) {
                    logger.error("Error animating balance change to: " + toNumberFinal + " - " + e.getMessage(), (Throwable)e);
                }
                finally {
                    this.updateCreditLabelOnEventThread(toStringFinal);
                }
                logger.debug("Completed balance change animation");
            });
            t.setDaemon(true);
            t.start();
        } else {
            logger.debug("Update balance without animation.");
            this._creditLabel.setText(to);
        }
    }

    private void updateCreditLabelOnEventThread(String value) {
        if (SwingUtilities.isEventDispatchThread()) {
            this._creditLabel.setText(value);
        } else {
            SwingUtilities.invokeLater(() -> this._creditLabel.setText(value));
        }
    }

    private static String format(String key, String ... args) {
        String fullKey = "UserClientFrame." + key;
        return Messages.getString(UserClient.class, fullKey, args);
    }

    static String getMessage(String key) {
        String fullKey = "UserClientFrame." + key;
        return Messages.getString(UserClient.class, fullKey, (String[])null);
    }

    ImageIcon createImageIcon(String path) {
        URL imgURL = this.getClass().getResource(path);
        if (imgURL != null) {
            return new ImageIcon(imgURL);
        }
        logger.debug("Unable to load image: " + path);
        return null;
    }

    private ServerConnection getServerConnection() {
        return this._serverConnection;
    }

    private void shutdown() {
        logger.debug("Shutdown");
        this.setVisible(false);
        this.dispose();
        if (this._serverConnection != null) {
            try {
                this._serverConnection.clearAuthentication();
            }
            catch (Exception e) {
                logger.error("Unable to clear authentication on shutdown.", (Throwable)e);
            }
        }
        if (this.hasTaskTray()) {
            try {
                this.removeTaskTray();
            }
            catch (Throwable t) {
                logger.error("Error shutting down task tray: " + t.getMessage(), t);
            }
        }
        System.exit(0);
    }

    void removeTaskTray() {
        if (this.hasTaskTray()) {
            SystemTray tray = SystemTray.getSystemTray();
            tray.remove(this._trayIcon);
            Uninterruptibles.sleepUninterruptibly((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
        }
    }

    void exitIfAllowed() {
        if (this._initialisationComplete && (this._config.getServerUserConfig().isClientRequiredToPrint() || this._config.isDisallowExit())) {
            DialogUtils.showInformationMessageDialog((Component)this, (String)UserClientFrame.getMessage("warning"), (String)UserClientFrame.getMessage("close-warning"));
        } else {
            this.shutdown();
        }
    }

    void setPopupDialogIsDisplayed(boolean popupIsDisplayed) {
        if (popupIsDisplayed) {
            int state = this.getExtendedState();
            if (SystemUtils.IS_OS_MAC_OSX && (state & 1) != 0) {
                this.makeVisible();
            }
        }
        this.setAlwaysOnTop(popupIsDisplayed);
        this._popupDialogIsDisplayed = popupIsDisplayed;
    }

    private static Color parseRGBColor(String rgbHexString, Color defaultColor) {
        int color;
        try {
            color = Integer.parseInt(rgbHexString, 16);
        }
        catch (Exception e) {
            logger.debug("Could not parse RGB color value: " + rgbHexString, (Throwable)e);
            return defaultColor;
        }
        if (color < 0 || color > 0xFFFFFF) {
            logger.debug("Could not parse RGB color value.  Outside valid range: " + rgbHexString);
            return defaultColor;
        }
        return new Color(color);
    }

    public void setOfflineIcon(boolean offline) {
        ImageIcon image = this.createImageIcon(offline ? "images/client-offline-icon-64.png" : CLIENT_LOGO_STANDARD);
        this.setIconImage(image.getImage());
        if (this.hasTaskTray()) {
            this._trayIcon.setImage(image.getImage());
            if (offline) {
                this.setTaskTrayToolTip(UserClientFrame.getMessage("offline"));
            } else {
                this.restoreLastToolTipCreditText();
            }
        }
    }

    JPopupMenu getPopupMenu() {
        return this._popupMenu;
    }

    static {
        String TEXT_COLOR = "text-color";
        String LINK_COLOR = "link-color";
        String LINK_HOVER_COLOR = "link-hover-color";
        String ADDITIONAL_LINK_COLOR = "additional-link-color";
        String NEGATIVE_BALANCE_COLOR = "negative-balance-color";
        Properties uiDefaults = new Properties();
        try (InputStream in = UserClientFrame.class.getResourceAsStream("ui-defaults.properties");){
            uiDefaults.load(in);
        }
        catch (IOException e) {
            logger.debug("Unable to load ui-defaults.properties. " + e.getMessage(), (Throwable)e);
        }
        DEFAULT_TEXT_COLOR = UserClientFrame.parseRGBColor(uiDefaults.getProperty("text-color"), new Color(44634));
        DEFAULT_LINK_COLOR = UserClientFrame.parseRGBColor(uiDefaults.getProperty("link-color"), new Color(44634));
        DEFAULT_LINK_HOVER_COLOR = UserClientFrame.parseRGBColor(uiDefaults.getProperty("link-hover-color"), new Color(3781962));
        DEFAULT_ADDITIONAL_LINK_COLOR = UserClientFrame.parseRGBColor(uiDefaults.getProperty("additional-link-color"), new Color(1673515));
        DEFAULT_NEGATIVE_BALANCE_COLOR = UserClientFrame.parseRGBColor(uiDefaults.getProperty("negative-balance-color"), new Color(0xFF0000));
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.maybeShowPopup(e);
        }

        void maybeShowPopup(MouseEvent e) {
            if (e.isPopupTrigger() && !UserClientFrame.this.getPopupMenu().isVisible()) {
                UserClientFrame.this.getPopupMenu().show(e.getComponent(), e.getX(), e.getY());
            }
        }
    }
}

