/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common;

public enum ChargeToAccountType {
    PersonalAccount{

        @Override
        protected String getClientConfigName() {
            return "charge-personal";
        }
    }
    ,
    AccountFromList{

        @Override
        protected String getClientConfigName() {
            return "charge-account-list";
        }
    }
    ,
    AccountWithPin{

        @Override
        protected String getClientConfigName() {
            return "charge-account-pin";
        }
    }
    ,
    OtherUser{

        @Override
        protected String getClientConfigName() {
            return "print-as-user";
        }
    }
    ,
    ManagerPrint{

        @Override
        protected String getClientConfigName() {
            return null;
        }
    };


    protected abstract String getClientConfigName();

    public static ChargeToAccountType fromClientConfigValue(String name) {
        for (ChargeToAccountType type : ChargeToAccountType.values()) {
            String confName = type.getClientConfigName();
            if (confName == null || !confName.equals(name)) continue;
            return type;
        }
        return null;
    }
}

