/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.Messages;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.commons.lang.time.FastDateFormat;

public final class Formatter {
    private Formatter() {
    }

    public static String formatISODate(@Nullable Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd").format(date);
    }

    public static String formatISODateAndTime(@Nullable Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(date);
    }

    public static String formatISO8601BasicDateTime(@Nullable Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat("yyyyMMdd'T'HHmmss").format(date);
    }

    public static String formatISODateAndTime(Date date, Locale locale) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", locale).format(date);
    }

    public static String formatStandardDateTime(@Nullable Date date, @Nullable Locale locale) {
        if (date == null) {
            return "";
        }
        FastDateFormat fdf = FastDateFormat.getDateTimeInstance((int)2, (int)2, null, (Locale)locale);
        return fdf.format(date);
    }

    public static String formatStandardDate(@Nullable Date date, @Nullable Locale locale) {
        if (date == null) {
            return "";
        }
        FastDateFormat fdf = FastDateFormat.getDateInstance((int)2, null, (Locale)locale);
        return fdf.format(date);
    }

    public static String formatStandardTime(@Nullable Date date, @Nullable Locale locale) {
        if (date == null) {
            return "";
        }
        FastDateFormat fdf = FastDateFormat.getTimeInstance((int)2, null, (Locale)locale);
        return fdf.format(date);
    }

    public static String formatTime(@Nullable Date date, @Nullable Locale locale) {
        if (date == null) {
            return "";
        }
        FastDateFormat fdf = FastDateFormat.getInstance((String)"H:mm:ss", (Locale)locale);
        return fdf.format(date);
    }

    public static String formatTimeHM(@Nullable Date date, @Nullable Locale locale) {
        if (date == null) {
            return "";
        }
        FastDateFormat fdf = FastDateFormat.getInstance((String)"H:mm", (Locale)locale);
        return fdf.format(date);
    }

    public static String formatDateTimeFilename(@Nullable Date date) {
        if (date == null) {
            return "";
        }
        return new SimpleDateFormat("yyyy-MM-dd-HH-mm-ss").format(date);
    }

    public static String formatNumber(double value, int fractionDigits, @Nullable Locale locale) {
        return Formatter.getNumberFormat(fractionDigits, locale).format(value);
    }

    public static NumberFormat getNumberFormat(int fractionDigits, @Nullable Locale locale) {
        NumberFormat format = Formatter.getNumberFormat(locale);
        if (fractionDigits >= 0) {
            format.setMaximumFractionDigits(fractionDigits);
            format.setMinimumFractionDigits(fractionDigits);
        }
        return format;
    }

    public static String formatCurrency(double value, @Nullable Locale locale) {
        NumberFormat format = Formatter.getNumberCurrencyFormat(locale);
        return format.format(value);
    }

    public static String formatCurrency(double value, int fractionDigits, @Nullable Locale locale) {
        NumberFormat format = Formatter.getNumberCurrencyFormat(locale);
        if (fractionDigits >= 0) {
            format.setMaximumFractionDigits(fractionDigits);
            format.setMinimumFractionDigits(fractionDigits);
        }
        return format.format(value);
    }

    public static String formatPercentage(double value, int fractionDigits, @Nullable Locale locale) {
        NumberFormat format = Formatter.getNumberPercentageFormat(locale);
        format.setMaximumFractionDigits(fractionDigits);
        format.setMinimumFractionDigits(fractionDigits);
        return format.format(value);
    }

    public static double parseDouble(String value, @Nullable Locale locale) {
        Number number;
        try {
            number = Formatter.getNumberFormat(locale).parse(value);
        }
        catch (ParseException e) {
            throw new NumberFormatException(e.getLocalizedMessage());
        }
        return number.doubleValue();
    }

    public static double parsePercentage(String value, @Nullable Locale locale) {
        Number number;
        try {
            number = Formatter.getNumberPercentageFormat(locale).parse(value);
        }
        catch (ParseException e) {
            return Formatter.parseDouble(value, locale) / 100.0;
        }
        return number.doubleValue();
    }

    public static String formatInteger(int value, @Nullable Locale locale) {
        return Formatter.formatInteger(value, 1, locale);
    }

    public static String formatInteger(int value, int minimumIntDigits, @Nullable Locale locale) {
        return Formatter.formatWithLocale(value, minimumIntDigits, locale);
    }

    public static String formatLong(long value, @Nullable Locale locale) {
        return Formatter.formatLong(value, 1, locale);
    }

    public static String formatLong(long value, int minimumIntDigits, @Nullable Locale locale) {
        return Formatter.formatWithLocale(value, minimumIntDigits, locale);
    }

    static String formatWithLocale(long value, int minimumIntDigits, @Nullable Locale locale) {
        NumberFormat format = Formatter.getNumberFormat(locale);
        format.setMaximumFractionDigits(0);
        format.setMinimumIntegerDigits(minimumIntDigits);
        return format.format(value);
    }

    public static String formatHours(double hours, @Nullable Locale locale) {
        int minsPerHour = 60;
        int hoursInt = (int)hours;
        int minsInt = (int)Math.round((hours - (double)hoursInt) * 60.0);
        return Formatter.formatInteger(hoursInt, locale) + ":" + Formatter.formatInteger(minsInt, 2, locale);
    }

    public static String formatMegabytes(double mb, @Nullable Locale locale) {
        return Formatter.formatNumber(mb, 2, locale);
    }

    public static String formatBooleanYesNo(boolean value, @Nullable Locale locale) {
        return Messages.getString(Formatter.class, locale, value ? "yes" : "no", new String[0]);
    }

    @Nullable
    public static String stripNonNumeric(@Nullable String str) {
        int end;
        int start;
        int strLen;
        String allowedChars = "-+0123456789.";
        if (str == null || (strLen = str.length()) == 0) {
            return str;
        }
        for (start = 0; start != strLen && allowedChars.indexOf(str.charAt(start)) < 0; ++start) {
        }
        for (end = strLen; end >= start && allowedChars.indexOf(str.charAt(end - 1)) < 0; --end) {
        }
        String r = str.substring(start, end);
        return r;
    }

    private static NumberFormat getNumberFormat(@Nullable Locale locale) {
        if (locale == null) {
            return NumberFormat.getInstance();
        }
        return NumberFormat.getInstance(locale);
    }

    private static NumberFormat getNumberPercentageFormat(@Nullable Locale locale) {
        if (locale == null) {
            return NumberFormat.getPercentInstance();
        }
        return NumberFormat.getPercentInstance(locale);
    }

    private static NumberFormat getNumberCurrencyFormat(@Nullable Locale locale) {
        if (locale == null) {
            return NumberFormat.getCurrencyInstance();
        }
        return NumberFormat.getCurrencyInstance(locale);
    }
}

