/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReentrantLockHelper {
    private static final Logger logger = LoggerFactory.getLogger(ReentrantLockHelper.class);
    private int _threadsWaitingForOrHoldingLocks;
    private final Map<Object, ReentrantLock> _locks = Collections.synchronizedMap(new HashMap());
    private final int _waitForLockTimeoutSecs;
    private final String _lockDescription;
    private final boolean _useFairLocks;

    public ReentrantLockHelper(String description, int lockTimeoutSecs, boolean useFairLocks) {
        this._lockDescription = StringUtils.trimToEmpty((String)description);
        this._waitForLockTimeoutSecs = lockTimeoutSecs;
        this._useFairLocks = useFairLocks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runWithLock(Object lockKey, Runnable runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Cannot use a null runnable to runWithLock");
        }
        this.acquireLock(lockKey);
        long acquiredLockTime = System.currentTimeMillis();
        try {
            runnable.run();
        }
        finally {
            this.releaseLock(lockKey);
            if (logger.isDebugEnabled()) {
                long releasedLockTime = System.currentTimeMillis();
                logger.debug("Unlocked " + this._lockDescription + " '" + lockKey + "'. Held: " + (releasedLockTime - acquiredLockTime) + " ms");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T runWithLock(Object lockKey, RunnableWithResult<T> runnable) {
        if (runnable == null) {
            throw new IllegalArgumentException("Cannot use a null runnable to runWithLock");
        }
        this.acquireLock(lockKey);
        long acquiredLockTime = System.currentTimeMillis();
        try {
            T t = runnable.run();
            return t;
        }
        finally {
            this.releaseLock(lockKey);
            if (logger.isDebugEnabled()) {
                long releasedLockTime = System.currentTimeMillis();
                logger.debug("Unlocked " + this._lockDescription + " '" + lockKey + "'. Held: " + (releasedLockTime - acquiredLockTime) + " ms");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireLock(Object lockKey) {
        ReentrantLock lock;
        if (lockKey == null) {
            throw new IllegalArgumentException("Lock key cannot be null");
        }
        Map<Object, ReentrantLock> map = this._locks;
        synchronized (map) {
            lock = this._locks.get(lockKey);
            if (lock == null) {
                lock = new ReentrantLock(this._useFairLocks);
                this._locks.put(lockKey, lock);
            }
            ++this._threadsWaitingForOrHoldingLocks;
        }
        boolean gotLock = false;
        try {
            long tryLockTime = 0L;
            if (logger.isDebugEnabled()) {
                logger.debug("Get lock - " + this._lockDescription + " '" + lockKey + "' {" + lock.getQueueLength() + "}");
                tryLockTime = System.currentTimeMillis();
            }
            if (!lock.tryLock(this._waitForLockTimeoutSecs, TimeUnit.SECONDS)) {
                throw new ObtainLockException("Could not obtain the lock for " + this._lockDescription + " '" + lockKey + "' within " + this._waitForLockTimeoutSecs + " secs.' {" + lock.getQueueLength() + "}");
            }
            gotLock = true;
            if (logger.isDebugEnabled()) {
                long gotLockTime = System.currentTimeMillis();
                logger.debug("Locked - " + this._lockDescription + " '" + lockKey + "'. Waited: " + (gotLockTime - tryLockTime) + " ms");
            }
        }
        catch (InterruptedException ie) {
            throw new ObtainLockException("Could not obtain the lock for " + this._lockDescription + "'" + lockKey + "'");
        }
        finally {
            if (!gotLock) {
                Map<Object, ReentrantLock> map2 = this._locks;
                synchronized (map2) {
                    --this._threadsWaitingForOrHoldingLocks;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock(Object lockKey) {
        boolean released = false;
        try {
            ReentrantLock lock = this._locks.get(lockKey);
            if (lock != null) {
                lock.unlock();
                released = true;
            }
        }
        finally {
            if (released) {
                Map<Object, ReentrantLock> map = this._locks;
                synchronized (map) {
                    --this._threadsWaitingForOrHoldingLocks;
                    if (this._threadsWaitingForOrHoldingLocks <= 0) {
                        this._locks.clear();
                        this._threadsWaitingForOrHoldingLocks = 0;
                    }
                }
            }
        }
    }

    public final boolean isLockIsHeldByCurrentThread(Object lockKey) {
        ReentrantLock lock = this._locks.get(lockKey);
        return lock != null && lock.isHeldByCurrentThread();
    }

    public final int getWaitForLockTimeoutSecs() {
        return this._waitForLockTimeoutSecs;
    }

    public static class ObtainLockException
    extends RuntimeException {
        private ObtainLockException(String message, Throwable cause) {
            super(message, cause);
        }

        private ObtainLockException(String message) {
            super(message);
        }
    }

    public static interface RunnableWithResult<V> {
        public V run();
    }
}

