#!/bin/zsh

#
# (c) Copyright 1999-2006 PaperCut Software International Pty Ltd
#
# This command script fixes startup problems on versions prior to 10.3.9.
# These earlier Mac versions don't have the required GGC libs so we use
# the old stub already available on the system.

#
# Make sure our current working dir is set to the location of this script
#
if [ -d /Applications/PCClient.app ]; then
	cd /Applications/PCClient.app/Contents/Resources
else
	cd "${0:h}"
fi

app_dir=`(cd ../..; pwd)`

echo
echo
echo "Enter your admin password if requested..."

#
# Link in the old stub
#
sudo sh -c "(
    mv \"${app_dir}/Contents/MacOS/JavaApplicationStub\" \"${app_dir}/Contents/MacOS/JavaApplicationStub.old\"
    ln -s /System/Library/Frameworks/JavaVM.framework/Resources/MacOS/JavaApplicationStub \"${app_dir}/Contents/MacOS/JavaApplicationStub\" 
    )"

echo "Complete."
