/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.common.client.dialogrequest;

import biz.papercut.pcng.common.client.dialogrequest.ClientDialogResponse;
import biz.papercut.pcng.util.ObjectUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ClientDialogRequest {
    private static final Logger logger = LoggerFactory.getLogger(ClientDialogRequest.class);
    public static final String ARG_UNIQUE_ID = "uniqueID";
    public static final String ARG_DIALOG_DESC = "dialogDesc";
    public static final String ARG_DIALOG_TITLE = "dialogTitle";
    public static final String ARG_HIDE_JOB_DETAILS = "hideJobDetails";
    protected final Map<String, Object> _data;

    protected ClientDialogRequest(String uniqueID, Map<String, Object> optionalArgs) {
        this._data = Collections.synchronizedMap(new HashMap(optionalArgs.size() + 1));
        this._data.put(ARG_UNIQUE_ID, uniqueID);
        this.validatedSupportedArgs(optionalArgs);
        this.loadOptionalArgs(optionalArgs);
    }

    protected ClientDialogRequest(Hashtable<String, Object> data) {
        this._data = Collections.synchronizedMap(new HashMap());
        String uniqueID = (String)data.get(ARG_UNIQUE_ID);
        if (uniqueID == null) {
            throw new IllegalArgumentException("Missing required uniqueID");
        }
        this._data.put(ARG_UNIQUE_ID, uniqueID);
        this.loadOptionalArgs(data);
    }

    protected Set<String> getSupportedArgNames() {
        HashSet<String> r = new HashSet<String>();
        r.add(ARG_UNIQUE_ID);
        r.add(ARG_DIALOG_DESC);
        r.add(ARG_DIALOG_TITLE);
        r.add(ARG_HIDE_JOB_DETAILS);
        return r;
    }

    private void validatedSupportedArgs(Map<String, Object> args) {
        Set<String> valid = this.getSupportedArgNames();
        for (String argName : args.keySet()) {
            if (valid.contains(argName)) continue;
            logger.warn("Unexpected argument '" + argName + "' for dialog type '" + this.getDialogTypeName() + "'. Argument will be ignored.");
        }
    }

    private void loadOptionalArgs(Map<String, Object> optionalArgs) {
        this.loadOptionalArgString(ARG_DIALOG_TITLE, optionalArgs);
        this.loadOptionalArgString(ARG_DIALOG_DESC, optionalArgs);
        this.loadOptionalArgBoolean(ARG_HIDE_JOB_DETAILS, optionalArgs);
    }

    protected final void loadOptionalArgString(String name, Map<String, Object> optionalArgs) {
        Object value = optionalArgs.get(name);
        if (value != null) {
            if (value instanceof CharSequence) {
                this._data.put(name, value.toString());
            } else {
                logger.warn("Client dialog argument '" + name + "' is not type string: " + value);
            }
        }
    }

    protected final void loadOptionalArgBoolean(String name, Map<String, Object> optionalArgs) {
        Object value = optionalArgs.get(name);
        if (value != null) {
            if (value instanceof Boolean) {
                this._data.put(name, value);
            } else {
                logger.warn("Client dialog argument '" + name + "' is not type boolean: " + value);
            }
        }
    }

    public final String getUniqueID() {
        return (String)this._data.get(ARG_UNIQUE_ID);
    }

    public final String getDialogTitle() {
        return (String)this._data.get(ARG_DIALOG_TITLE);
    }

    public final String getDialogDescription() {
        return (String)this._data.get(ARG_DIALOG_DESC);
    }

    public final boolean getHideJobDetails() {
        Boolean b = (Boolean)this._data.get(ARG_HIDE_JOB_DETAILS);
        if (b == null) {
            return false;
        }
        return b;
    }

    public final Hashtable<String, Object> saveToHashtable() {
        Hashtable<String, Object> data = new Hashtable<String, Object>();
        data.put("type", this.getDialogTypeName());
        data.putAll(this._data);
        return data;
    }

    public abstract String getDialogTypeName();

    public abstract ClientDialogResponse parseResponse(Hashtable<String, Object> var1);

    public String toString() {
        return ObjectUtils.createToStringBuilder(this).append(this._data).toString();
    }
}

