/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.BasePrintDialog;
import biz.papercut.pcng.client.uit.Messages;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogResponse;
import biz.papercut.pcng.common.client.dialogrequest.MessageDialogRequest;
import biz.papercut.pcng.common.client.dialogrequest.MessageDialogResponse;
import biz.papercut.pcng.util.BrowserLinkUtils;
import com.jgoodies.forms.factories.ButtonBarFactory;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomMessagePrintDialog
extends BasePrintDialog {
    private static final Logger logger = LoggerFactory.getLogger(CustomMessagePrintDialog.class);
    private final JButton[] _buttons;
    protected JEditorPane _message;
    protected final ServerConnection _conn;
    protected final MessageDialogRequest _request;
    protected final ClientPrintJob _job;

    public static CustomMessagePrintDialog construct(JFrame owner, MessageDialogRequest request, ClientPrintJob job, ServerConnection conn, UserClientConfig config) {
        CustomMessagePrintDialog d = new CustomMessagePrintDialog(owner, request, job, conn, config);
        d.initializeMessageDialog();
        return d;
    }

    protected CustomMessagePrintDialog(JFrame owner, MessageDialogRequest request, ClientPrintJob job, ServerConnection conn, UserClientConfig config) {
        super(owner, config);
        this._request = request;
        this._conn = conn;
        this._job = job;
        ActionListener buttonListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JButton pressed = (JButton)e.getSource();
                logger.debug("Button pressed: " + pressed.getText());
                for (int i = 0; i < CustomMessagePrintDialog.this._buttons.length; ++i) {
                    String name;
                    if (pressed != CustomMessagePrintDialog.this._buttons[i] || !CustomMessagePrintDialog.this.handleButtonPress(name = (String)CustomMessagePrintDialog.this._request.getButtons().get(i))) continue;
                    CustomMessagePrintDialog.this.setVisible(false);
                }
            }
        };
        this._buttons = new JButton[request.getButtons().size()];
        for (int i = 0; i < this._buttons.length; ++i) {
            String buttonName = (String)request.getButtons().get(i);
            buttonName = this.translateButtonNameIfRequired(buttonName);
            this._buttons[i] = new JButton(buttonName);
            this._buttons[i].addActionListener(buttonListener);
        }
    }

    protected boolean handleButtonPress(String button) {
        this._conn.setClientDialogResponse(this._job.getJobId(), this._request.getUniqueID(), (ClientDialogResponse)new MessageDialogResponse(button));
        return true;
    }

    protected void initializeMessageDialog() {
        String dialogDesc;
        String dialogTitle = this._request.getDialogTitle();
        if (StringUtils.isBlank((String)dialogTitle)) {
            dialogTitle = Messages.getString(this.getClass(), "SelectAccount.title", new String[0]);
        }
        if (StringUtils.isBlank((String)(dialogDesc = this._request.getDialogDescription()))) {
            dialogDesc = Messages.getString(this.getClass(), "SelectAccount.description", new String[0]);
        }
        this.initializeBase(dialogTitle, dialogDesc, true, this._request.getHideJobDetails() ? BasePrintDialog.ShowPrintJobOptions.ShowNone : (this._job.isPreNotification() ? BasePrintDialog.ShowPrintJobOptions.ShowBasicOnly : BasePrintDialog.ShowPrintJobOptions.ShowAll));
        String htmlMessage = this.convertToHTMLIfRequired(this._request.getMessage());
        htmlMessage = this.expandVars(htmlMessage);
        this._message.setText(htmlMessage);
        this.displayJobDetails(this._job);
    }

    private String translateButtonNameIfRequired(String buttonName) {
        if (buttonName.equalsIgnoreCase("OK")) {
            return Messages.getString(this.getClass(), "Dialog.ok", new String[0]);
        }
        if (buttonName.equalsIgnoreCase("PRINT")) {
            return Messages.getString(this.getClass(), "Dialog.print", new String[0]);
        }
        if (buttonName.equalsIgnoreCase("CANCEL")) {
            return Messages.getString(this.getClass(), "Dialog.cancel", new String[0]);
        }
        if (buttonName.equalsIgnoreCase("YES")) {
            return Messages.getString(this.getClass(), "Dialog.yes", new String[0]);
        }
        if (buttonName.equalsIgnoreCase("NO")) {
            return Messages.getString(this.getClass(), "Dialog.no", new String[0]);
        }
        return buttonName;
    }

    @Override
    protected JPanel constructButtonPanel() {
        JPanel p = ButtonBarFactory.buildRightAlignedBar((JButton[])this._buttons);
        p.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 5));
        return p;
    }

    @Override
    protected JPanel constructMainPanel() {
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(20, 10, 20, 10));
        Object html = this.convertToHTMLIfRequired(this._request.getMessage());
        html = this.expandVars((String)html);
        html = this.unwrapHTMLTag((String)html, "html");
        html = this.unwrapHTMLTag((String)html, "body");
        html = "<html><div style='width: 400px'>" + (String)html + "</div></html>";
        JEditorPane jep = new JEditorPane("text/html", (String)html);
        jep.setEditable(false);
        jep.setOpaque(false);
        jep.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        jep.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent hle) {
                String link;
                if (HyperlinkEvent.EventType.ACTIVATED.equals(hle.getEventType()) && StringUtils.isNotBlank((String)(link = hle.getDescription()))) {
                    logger.debug("Opening link in browser: " + link);
                    BrowserLinkUtils.openBrowser((String)link);
                }
            }
        });
        this._message = jep;
        JScrollPane scrollPane = new JScrollPane(jep);
        scrollPane.setBorder(null);
        p.add((Component)scrollPane, "Center");
        return p;
    }

    @Override
    protected JButton getDefaultButton() {
        if (this._buttons.length == 1) {
            return this._buttons[0];
        }
        return null;
    }

    @Override
    protected boolean handleWindowClosing(WindowEvent e) {
        for (String buttonName : this._request.getButtons()) {
            if (!buttonName.equalsIgnoreCase("Cancel")) continue;
            this._conn.setClientDialogResponse(this._job.getJobId(), this._request.getUniqueID(), (ClientDialogResponse)new MessageDialogResponse(buttonName));
            return true;
        }
        return false;
    }

    private String convertToHTMLIfRequired(String message) {
        String msgLower = message.trim().toLowerCase();
        if (msgLower.startsWith("<html>") && msgLower.endsWith("</html>")) {
            return message;
        }
        Object html = message;
        html = message.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\r", "").replace("\n", "<br/>");
        html = "<html>" + (String)html + "</html>";
        if (logger.isDebugEnabled()) {
            logger.debug("Converted message to HTML. Original: " + message + ", HTML: " + (String)html);
        }
        return html;
    }

    private String expandVars(String message) {
        String pcServerVar = "%PC_SERVER%";
        if (message.contains("%PC_SERVER%")) {
            String serverConnName = this._conn.getConnectionName() + ":" + String.valueOf(this._conn.getConnectionPort());
            message = message.replaceAll("%PC_SERVER%", serverConnName);
        }
        return message;
    }

    private String unwrapHTMLTag(String html, String tagName) {
        html = html.trim();
        String lower = html.trim().toLowerCase();
        tagName = tagName.toLowerCase();
        String start = "<" + tagName + ">";
        String end = "</" + tagName + ">";
        if (lower.startsWith(start) && lower.endsWith(end)) {
            html = html.substring(start.length());
            html = html.substring(0, html.length() - end.length());
        }
        return html;
    }
}

