/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.Messages;
import biz.papercut.pcng.common.ChargeRate;
import biz.papercut.pcng.common.ChargeToAccountType;
import biz.papercut.pcng.common.ClientAccount;
import biz.papercut.pcng.common.ClientAccountFile;
import biz.papercut.pcng.common.ClientAction;
import biz.papercut.pcng.common.ClientAuthResponse;
import biz.papercut.pcng.common.ClientGlobalConfigFromServer;
import biz.papercut.pcng.common.ClientJobUpdateResponse;
import biz.papercut.pcng.common.ClientPopupInfo;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.common.ClientPrintPopupConfig;
import biz.papercut.pcng.common.ClientUserConfigFromServer;
import biz.papercut.pcng.common.UserDetails;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogRequestWithJobInfo;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogResponse;
import biz.papercut.pcng.util.ApplicationException;
import biz.papercut.pcng.util.NetworkUtils;
import biz.papercut.pcng.util.swing.DialogUtils;
import com.google.common.util.concurrent.Uninterruptibles;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.NetworkInterface;
import java.net.NoRouteToHostException;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Vector;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.net.ssl.SSLHandshakeException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;
import org.apache.xmlrpc.XmlRpc;
import org.apache.xmlrpc.XmlRpcClient;
import org.apache.xmlrpc.XmlRpcException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerConnection {
    private static final Logger logger = LoggerFactory.getLogger(ServerConnection.class);
    private static final String RPC_PATH = "/rpc/clients/xmlrpc";
    private static final String IP_ADDRESS_SEPARATOR = ",";
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";
    private XmlRpcClient _xmlRpcClient;
    private XmlRpcClient _secureXmlRpcClient;
    private final String _serverName;
    private final String _serverIP;
    private final int _serverPort;
    private boolean _useIP;
    private int _sslPort;
    private String _userName;
    private final String _machineName;
    private String _allIpAddresses;
    private String _sessionToken;
    private volatile long _ipAddressCacheExpiryTime;
    private final boolean _connected;
    private final boolean _requireSSLWhenRequested;
    private String _lastConnectionAttemptError;
    private static final long IP_CACHE_TIMEOUT_MILLIS = 60000L;

    public ServerConnection(String serverName, String serverIP, int serverPort, int timeoutSecs, boolean retryUntilConnect, boolean requireSSLWhenRequested) {
        block6: {
            this._sslPort = -1;
            this._allIpAddresses = "";
            this._sessionToken = "";
            this._serverName = serverName;
            this._serverPort = serverPort;
            this._serverIP = this.attachScopeIDIfNeeded(serverIP);
            this._machineName = StringUtils.trimToEmpty((String)NetworkUtils.getComputerName());
            this._requireSSLWhenRequested = requireSSLWhenRequested;
            this.loadAllIpAddressesIfRequired();
            System.setProperty("sun.net.client.defaultReadTimeout", String.valueOf(timeoutSecs * 1000));
            System.setProperty("sun.net.client.defaultConnectTimeout", String.valueOf(timeoutSecs * 1000));
            XmlRpc.setKeepAlive((boolean)true);
            XmlRpc.setDefaultInputEncoding((String)"UTF8");
            XmlRpc.setEncoding((String)"UTF8");
            double perturbation = new Random().nextDouble();
            double retryDelayIncrementSecs = 1.0 + perturbation;
            double retryDelaySecs = 4.0 + 2.0 * perturbation;
            double maxRetryDelaySecs = 30.0;
            while (true) {
                this._lastConnectionAttemptError = "";
                boolean pass = true;
                this._useIP = false;
                if (!this.connect(PROTOCOL_HTTP)) {
                    this._useIP = true;
                    if (!this.connect(PROTOCOL_HTTP)) {
                        this._useIP = false;
                        if (!this.connect(PROTOCOL_HTTPS)) {
                            this._useIP = true;
                            if (!this.connect(PROTOCOL_HTTPS)) {
                                pass = false;
                            }
                        }
                    }
                }
                if (pass) break block6;
                if (!retryUntilConnect) break;
                logger.debug("Retry connection in: {} secs.", (Object)retryDelaySecs);
                Uninterruptibles.sleepUninterruptibly((long)((int)retryDelaySecs), (TimeUnit)TimeUnit.SECONDS);
                if (!((retryDelaySecs += retryDelayIncrementSecs) > 30.0)) continue;
                retryDelaySecs = 30.0;
            }
            logger.error("Unable to establish connection with server: {}", (Object)serverName);
            this._lastConnectionAttemptError = StringUtils.trimToEmpty((String)this._lastConnectionAttemptError);
            int methodIndex = this._lastConnectionAttemptError.lastIndexOf(" Method: ");
            if (methodIndex >= 0) {
                this._lastConnectionAttemptError = this._lastConnectionAttemptError.substring(0, methodIndex);
            }
            throw new ServerConnectionException("Unable to establish connection with the server: " + serverName + (String)(StringUtils.isNotBlank((String)this._lastConnectionAttemptError) ? "\n\n" + this._lastConnectionAttemptError : ""));
        }
        this._connected = true;
    }

    public ServerConnection(String serverName, String serverIP, int serverPort, boolean requireSSLWhenRequested) {
        this._sslPort = -1;
        this._allIpAddresses = "";
        this._sessionToken = "";
        this._serverName = serverName;
        this._machineName = "testHost";
        this._serverPort = serverPort;
        this._serverIP = this.attachScopeIDIfNeeded(serverIP);
        this._requireSSLWhenRequested = requireSSLWhenRequested;
        this._connected = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean connect(String protocol) {
        boolean result = false;
        try {
            URL url = new URL(protocol, this._useIP ? this._serverIP : this._serverName, this._serverPort, RPC_PATH);
            logger.debug("Attempting to connect using server's {}: {}", (Object)(this._useIP ? "IP" : "name"), (Object)url);
            if (PROTOCOL_HTTPS.equals(protocol)) {
                this._secureXmlRpcClient = new XmlRpcClient(url);
            } else {
                this._xmlRpcClient = new XmlRpcClient(url);
            }
            result = this.ping();
            if (result && PROTOCOL_HTTPS.equals(protocol)) {
                this._sslPort = this._serverPort;
            }
            boolean bl = result;
            return bl;
        }
        catch (Exception e) {
            logger.debug("Failed to connect to server using {}. {}", new Object[]{this._useIP ? "ip address" : "server name", e.getMessage(), e});
            this._lastConnectionAttemptError = e.getMessage();
            boolean bl = false;
            return bl;
        }
        finally {
            if (!result) {
                this._xmlRpcClient = null;
                this._secureXmlRpcClient = null;
            }
        }
    }

    public void trySecureConnection() {
        this.setupSecureConnection();
    }

    private void setupSecureConnection() {
        URL url;
        if (this._sslPort <= 0) {
            logger.error("Invalid SSL port so not setting up SSL connection.");
            return;
        }
        String server = this._useIP ? this._serverIP : this._serverName;
        try {
            logger.debug("Configuring SSL connection to: {}:{}", (Object)server, (Object)this._sslPort);
            url = new URL(PROTOCOL_HTTPS, server, this._sslPort, RPC_PATH);
        }
        catch (MalformedURLException e) {
            throw new ServerConnectionException("Invalid URL.", e);
        }
        XmlRpc.setKeepAlive((boolean)true);
        XmlRpc.setDefaultInputEncoding((String)"UTF8");
        XmlRpc.setEncoding((String)"UTF8");
        this._secureXmlRpcClient = new XmlRpcClient(url);
    }

    List<ClientAction> getPendingActions(int timeoutSecs) {
        logger.debug("Requesting pending actions for: {}", (Object)this.getUserName());
        boolean actionInfoLevel = true;
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, false);
        params.add(timeoutSecs);
        params.add(1);
        Vector actionStrings = (Vector)this.execute("client.getPendingActions", params);
        if (actionStrings.isEmpty()) {
            return Collections.emptyList();
        }
        logger.debug("Got {} pending actions.", (Object)actionStrings.size());
        ArrayList<ClientAction> actions = new ArrayList<ClientAction>(actionStrings.size());
        for (String actionString : actionStrings) {
            try {
                actions.add(ClientAction.valueOf((String)actionString));
            }
            catch (IllegalArgumentException e) {
                logger.debug("Unknown action type: {}", (Object)actionString);
            }
        }
        return actions;
    }

    private boolean ping() {
        logger.debug("Pinging server");
        Vector<Object> params = new Vector<Object>();
        return (Boolean)this.execute("client.ping", params);
    }

    Vector<String> getPendingMessages() {
        logger.debug("Requesting pending messages for: {}", (Object)this.getUserName());
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, true);
        Vector msgs = (Vector)this.execute("client.getUserMessages", params);
        logger.debug("Got {} pending messages.", (Object)msgs.size());
        return msgs;
    }

    List<ClientPrintJob> getPendingPrintJobs() {
        logger.debug("Requesting pending print jobs for: {}", (Object)this.getUserName());
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, true);
        Vector result = (Vector)this.execute("client.getPendingPrintJobs", params);
        logger.debug("Got {} pending print jobs.", (Object)result.size());
        ArrayList<ClientPrintJob> jobs = new ArrayList<ClientPrintJob>(result.size());
        for (Hashtable jobHash : result) {
            jobs.add(new ClientPrintJob(jobHash));
        }
        return jobs;
    }

    int getPendingPrintJobCount() {
        logger.debug("Requesting pending print job count for: {}", (Object)this.getUserName());
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, true);
        return (Integer)this.execute("client.getPendingPrintJobCount", params);
    }

    void getUpdatedPrintJobInfo(ClientPrintJob job) {
        logger.debug("Getting updating job info for: {}", (Object)job.getJobId());
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, true);
        params.add(job.getJobId());
        Hashtable result = (Hashtable)this.execute("client.getPrintJobInfo", params);
        if (result.isEmpty()) {
            logger.debug("No updated job info returned for job id: {}", (Object)job.getJobId());
            return;
        }
        ClientPrintJob updatedJob = new ClientPrintJob(result);
        job.setDocumentName(updatedJob.getDocumentName());
        job.setFormattedCost(updatedJob.getFormattedCost());
        job.setPreNotification(updatedJob.isPreNotification());
        job.setPrinterName(updatedJob.getPrinterName());
        job.setServerName(updatedJob.getServerName());
        job.setTotalPages(updatedJob.getTotalPages());
        job.setColorPages(updatedJob.getColorPages());
    }

    void cancelPendingPrintJob(ClientPrintJob job, boolean cancelAllPending) {
        if (cancelAllPending) {
            this.updateAllPendingPrintJobs(job, true, new ClientPopupInfo());
        } else {
            this.updatePendingPrintJob(job, true, new ClientPopupInfo());
        }
    }

    ClientJobUpdateResponse updatePendingPrintJob(ClientPrintJob job, boolean cancelPrint, ClientPopupInfo popupInfo) {
        logger.debug("Updating print job: {}", (Object)job.getJobId());
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, true);
        params.add(job.getJobId());
        params.add(cancelPrint);
        params.add(this.buildAccountSelectionArgs(cancelPrint, popupInfo));
        Vector result = (Vector)this.execute("client.updatePendingPrintJob", params);
        if (((Boolean)result.get(0)).booleanValue()) {
            return new ClientJobUpdateResponse(true, false, "");
        }
        return new ClientJobUpdateResponse(((Boolean)result.get(0)).booleanValue(), ((Boolean)result.get(1)).booleanValue(), (String)result.get(2));
    }

    ClientJobUpdateResponse updateAllPendingPrintJobs(ClientPrintJob firstJob, boolean cancelPrint, ClientPopupInfo popupInfo) {
        logger.debug("Updating all print jobs. First JobId: {}", (Object)firstJob.getJobId());
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, true);
        params.add(firstJob.getJobId());
        params.add(cancelPrint);
        params.add(this.buildAccountSelectionArgs(cancelPrint, popupInfo));
        Hashtable result = (Hashtable)this.execute("client.updateAllPendingPrintJobs", params);
        return new ClientJobUpdateResponse(result);
    }

    String getUsersRecentAccounts(ClientPrintJob job) {
        logger.debug("Getting recent accounts for user associated with jobid: {}", (Object)job.getJobId());
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, true);
        params.add(job.getJobId());
        String accounts = (String)this.execute("client.getUsersRecentAccounts", params);
        logger.debug("Got recent accounts: {}", (Object)accounts);
        return accounts;
    }

    String getUsersPreferredAccounts(ClientPrintJob job) {
        logger.debug("Getting preferred accounts for user associated with jobid: {}", (Object)job.getJobId());
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, true);
        params.add(job.getJobId());
        String accounts = (String)this.execute("client.getUsersPreferredAccounts", params);
        logger.debug("Got Preferred accounts: {}", (Object)accounts);
        return accounts;
    }

    void setUsersPreferredAccounts(ClientPrintJob job, String preferredAccounts) {
        logger.debug("Setting preferred accounts for user associated with jobid: {}", (Object)job.getJobId());
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, true);
        params.add(job.getJobId());
        params.add(preferredAccounts);
        Boolean ret = (Boolean)this.execute("client.setUsersPreferredAccounts", params);
        if (!ret.booleanValue()) {
            throw new ServerConnectionException("Problem setting user's preferred Accounts");
        }
    }

    List<ChargeRate> getChargeRates(ClientPrintJob job) {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, true);
        params.add(job.getJobId());
        params.add(2);
        String rateStr = (String)this.execute("client.getChargeRates3", params);
        return ChargeRate.stringToList((String)rateStr);
    }

    ClientAuthResponse authenticateUser(String userName, String password, int preferredTTLSecs) {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, false);
        params.add(userName);
        params.add(password);
        params.add(preferredTTLSecs);
        params.add(this.getServerSocket());
        logger.debug("Authenticating user \"{}\" using preferred TTL {}", (Object)userName, (Object)preferredTTLSecs);
        Hashtable result = (Hashtable)this.execute("client.authenticateUser", params);
        return this.createClientAuthResponse(result);
    }

    private String getServerSocket() {
        String urlBody = "://" + this.getConnectionName() + ":" + this._serverPort;
        if (this.connect(PROTOCOL_HTTPS)) {
            return PROTOCOL_HTTPS + urlBody;
        }
        if (this.connect(PROTOCOL_HTTP)) {
            return PROTOCOL_HTTP + urlBody;
        }
        return "";
    }

    ClientAuthResponse authenticateUserByIdNumber(String idNumber, String pin, int preferredTTLSecs) {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, false);
        params.add(idNumber);
        params.add(pin);
        params.add(preferredTTLSecs);
        logger.debug("Authenticating Id Number \"{}\" using preferred TTL {}", (Object)idNumber, (Object)preferredTTLSecs);
        Hashtable result = (Hashtable)this.execute("client.authenticateUserByIdNumber", params);
        return this.createClientAuthResponse(result);
    }

    ClientAuthResponse authenticateUserWithSharedSecret(String userName, String sharedSecret, int preferredTTLSecs) {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, false);
        params.add(userName);
        params.add(sharedSecret);
        params.add(preferredTTLSecs);
        Hashtable result = (Hashtable)this.execute("client.authenticateUserWithSharedSecret", params);
        return this.createClientAuthResponse(result);
    }

    ClientAuthResponse authenticateUserWithCookie(String authCookie) {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, false);
        params.add(authCookie);
        Hashtable result = (Hashtable)this.execute("client.authenticateUserWithCookie", params);
        return this.createClientAuthResponse(result);
    }

    @Nullable
    ClientAuthResponse authenticateUserViaMfa(String userName, int preferredTTLSecs) {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, false);
        params.add(userName);
        params.add(preferredTTLSecs);
        Hashtable result = (Hashtable)this.execute("client.authenticateUserViaMfa", params);
        ClientAuthResponse resp = this.createClientAuthResponse(result);
        if (resp.isMfaRequired() && StringUtils.isBlank((String)resp.getErrorMessage()) && StringUtils.isBlank((String)resp.getExtAuthUrl())) {
            return null;
        }
        return resp;
    }

    boolean clearAuthentication() {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, false);
        return (Boolean)this.execute("client.clearAuthentication", params);
    }

    ClientAuthResponse checkIdentity(String userName, String password) {
        Vector<Object> params = new Vector<Object>();
        params.add(userName);
        params.add(password);
        this.appendClientIdentityParams(params, false);
        params.add(this.getServerSocket());
        Hashtable result = (Hashtable)this.execute("client.checkIdentity", params);
        return this.createClientAuthResponse(result);
    }

    ClientAuthResponse checkIdentityViaMfa(String username) {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, false);
        params.add(username);
        Hashtable result = (Hashtable)this.execute("client.checkIdentityViaMfa", params);
        ClientAuthResponse resp = this.createClientAuthResponse(result);
        if (resp.isMfaRequired() && StringUtils.isBlank((String)resp.getErrorMessage()) && StringUtils.isBlank((String)resp.getExtAuthUrl())) {
            return null;
        }
        return resp;
    }

    boolean tryPrintAsAnotherUserViaMfa(ClientPrintJob job, boolean applyToAll, ClientPopupInfo popupInfo) {
        logger.debug("Notifying the app server that user {} will soon authenticate as {} for printing", (Object)this.getUserName(), (Object)popupInfo.getUserName());
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, true);
        params.add(job.getJobId());
        params.add(applyToAll);
        params.add(this.buildAccountSelectionArgs(false, popupInfo));
        boolean result = (Boolean)this.execute("client.tryPrintAsAnotherUserViaMfa", params);
        logger.debug("Print as another user success? {}", (Object)result);
        return result;
    }

    private Hashtable<String, Object> buildAccountSelectionArgs(boolean cancelPrint, ClientPopupInfo popupInfo) {
        Hashtable<String, Object> args = new Hashtable<String, Object>();
        if (!cancelPrint) {
            if (popupInfo.getChargeToAccountType() == null) {
                popupInfo.setChargeToAccountType(ChargeToAccountType.PersonalAccount);
            }
            args.put("account-to-charge-type", popupInfo.getChargeToAccountType().name());
            switch (popupInfo.getChargeToAccountType()) {
                case PersonalAccount: {
                    break;
                }
                case AccountWithPin: {
                    args.put("account-pin", ClientPopupInfo.encodePassword((String)popupInfo.getAccountPin()));
                    break;
                }
                case AccountFromList: {
                    args.put("account-id", String.valueOf(popupInfo.getAccountId()));
                    break;
                }
                case OtherUser: {
                    args.put("username", popupInfo.getUserName());
                    args.put("password", ClientPopupInfo.encodePassword((String)popupInfo.getPassword()));
                    break;
                }
                case ManagerPrint: {
                    args.put("username", popupInfo.getUserName());
                    if (StringUtils.isNotBlank((String)popupInfo.getAccountPin())) {
                        args.put("account-pin", ClientPopupInfo.encodePassword((String)popupInfo.getAccountPin()));
                        break;
                    }
                    args.put("account-id", String.valueOf(popupInfo.getAccountId()));
                    break;
                }
                default: {
                    logger.error("Unknown handled account charge-to type: {}", (Object)popupInfo.getChargeToAccountType());
                }
            }
        }
        if (StringUtils.isNotBlank((String)popupInfo.getComment())) {
            args.put("job-comment", popupInfo.getComment());
        }
        if (popupInfo.getInvoice() != null) {
            args.put("job-invoice", popupInfo.getInvoice());
        }
        if (popupInfo.getChargeRates() != null && !popupInfo.getChargeRates().isEmpty()) {
            args.put("charge-rate", ChargeRate.listToString((List)popupInfo.getChargeRates(), (boolean)false));
        }
        return args;
    }

    private synchronized void appendClientIdentityParams(Vector<Object> params, boolean token) {
        this.loadAllIpAddressesIfRequired();
        if (StringUtils.isBlank((String)this.getUserName())) {
            throw new ApplicationException("setUserName() must be set when calling this method");
        }
        params.add(this.getUserName());
        params.add(this.getMachineName());
        params.add(this.getAllIpAddresses());
        if (token) {
            params.add(this.getSessionToken());
        }
    }

    private synchronized void loadAllIpAddressesIfRequired() {
        if (System.currentTimeMillis() > this._ipAddressCacheExpiryTime) {
            String previousIpAddresses = this._allIpAddresses;
            StringBuilder sb = new StringBuilder();
            for (String ip : NetworkUtils.getAllIpAddresses()) {
                if (!sb.isEmpty()) {
                    sb.append(IP_ADDRESS_SEPARATOR);
                }
                sb.append(ip);
            }
            this._allIpAddresses = sb.toString();
            this._ipAddressCacheExpiryTime = System.currentTimeMillis() + 60000L;
            if (logger.isDebugEnabled()) {
                logger.debug("Client's list of IP addresses is: {}. {}", (Object)this._allIpAddresses, this._allIpAddresses.equals(previousIpAddresses) ? " Unchanged." : " Previously: " + previousIpAddresses);
            }
        }
    }

    ClientGlobalConfigFromServer getGlobalConfig() {
        logger.debug("Requesting global config data from server");
        Vector<Object> params = new Vector<Object>();
        params.add(this.getMachineName());
        params.add(this.getAllIpAddresses());
        Hashtable data = (Hashtable)this.execute("client.getGlobalConfig", params);
        ClientGlobalConfigFromServer cc = new ClientGlobalConfigFromServer(data);
        logger.debug("Server SSL Port: {}", (Object)cc.getSslPort());
        if (cc.getSslPort() > 0) {
            if (this._secureXmlRpcClient != null) {
                logger.debug("Already connected on SSL port {}. Ignoring server's global config SSL port.", (Object)this._sslPort);
            } else {
                this._sslPort = cc.getSslPort();
                this.setupSecureConnection();
            }
        }
        return cc;
    }

    ClientUserConfigFromServer getUserConfig() {
        logger.debug("Requesting user config data from server");
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, false);
        Hashtable data = (Hashtable)this.execute("client.getUserConfig", params);
        return new ClientUserConfigFromServer(data);
    }

    boolean userExists(String userName) {
        Vector<Object> params = new Vector<Object>();
        params.add(userName);
        return (Boolean)this.execute("client.userExists", params);
    }

    String getUserBalance(String userName) {
        logger.debug("Requesting user balance for user: {}", (Object)userName);
        Vector<Object> params = new Vector<Object>(3);
        this.appendClientIdentityParams(params, true);
        params.add(userName);
        String balance = (String)this.execute("client.getUserBalance", params);
        logger.debug("Got the balance: {}", (Object)balance);
        return balance;
    }

    UserDetails getUserDetails(String userNameOrId, boolean lookupID) {
        Vector<Object> params = new Vector<Object>(3);
        this.appendClientIdentityParams(params, true);
        params.add(userNameOrId);
        params.add(lookupID);
        Hashtable data = (Hashtable)this.execute("client.getUserDetails", params);
        if (data.isEmpty()) {
            return null;
        }
        return new UserDetails(data);
    }

    ClientPrintPopupConfig getPrintJobPopupConfig(ClientPrintJob job) {
        logger.debug("Requesting print job popup config for user {} and job id {}", (Object)this.getUserName(), (Object)job.getJobId());
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, true);
        params.add(job.getJobId());
        Hashtable data = (Hashtable)this.execute("client.getPrintJobPopupConfig", params);
        return new ClientPrintPopupConfig(data);
    }

    String getUserAccountsLastModifiedTime(ClientPrintJob job) {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, false);
        params.add(job.getJobId());
        return (String)this.execute("client.getUserAccountsLastModifiedTime", params);
    }

    List<ClientAccount> getUserAccounts(ClientPrintJob job, String username, boolean loadDisabledSharedAccounts) {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, true);
        params.add(job.getJobId());
        params.add(3);
        byte[] data = (byte[])this.execute("client.getUserAccountsFile", params);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            return ClientAccountFile.readClientAccountsFromStream((InputStream)bais, (int)3, (boolean)loadDisabledSharedAccounts);
        }
        catch (IOException e) {
            throw new ApplicationException("Error loading accounts from server: " + e.getMessage(), (Throwable)e);
        }
    }

    List<ClientAccount> getAllSharedAccounts(boolean loadDisabledSharedAccounts) {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, true);
        params.add(3);
        byte[] data = (byte[])this.execute("client.getAllSharedAccountsFile", params);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(data);
            return ClientAccountFile.readClientAccountsFromStream((InputStream)bais, (int)3, (boolean)loadDisabledSharedAccounts);
        }
        catch (IOException e) {
            throw new ApplicationException("Error loading accounts from server: " + e.getMessage(), (Throwable)e);
        }
    }

    List<ClientDialogRequestWithJobInfo> getPendingClientDialogs() {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, true);
        Vector v = (Vector)this.execute("client.getClientDialogs", params);
        ArrayList<ClientDialogRequestWithJobInfo> r = new ArrayList<ClientDialogRequestWithJobInfo>(v.size());
        for (Vector data : v) {
            try {
                ClientDialogRequestWithJobInfo d = new ClientDialogRequestWithJobInfo(data);
                if (d.getRequest() == null) {
                    logger.error("Unknown dialog type, client must be upgraded. Dialog data: {}", (Object)data);
                    DialogUtils.showWarningMessageDialog(null, (String)Messages.getString(this.getClass(), "UserClient.message", new String[0]), (String)Messages.getString(this.getClass(), "UserClient.unknown-dialog", new String[0]));
                    continue;
                }
                r.add(d);
            }
            catch (Exception e) {
                logger.error("Error occurred process dialog: {}", (Object)data, (Object)e);
            }
        }
        return r;
    }

    void setClientDialogResponse(String printEventID, String uniqueID, ClientDialogResponse response) {
        Vector<Object> params = new Vector<Object>();
        this.appendClientIdentityParams(params, true);
        params.add(printEventID);
        params.add(uniqueID);
        params.add(response.saveToHashtable());
        this.execute("client.setClientDialogResponse", params);
    }

    String getExtAuthUrlForPrintAsOtherUser(String otherUsername) {
        Vector<Object> params = new Vector<Object>();
        params.add(otherUsername);
        params.add(this.getMachineName());
        params.add(this.getAllIpAddresses());
        params.add(this.getSessionToken());
        params.add(this.getServerSocket());
        return (String)this.execute("client.getExtAuthUrlForPrintAsOtherUser", params);
    }

    private Object execute(String method, Vector<Object> parameters) {
        try {
            boolean hasCalled = false;
            Object result = null;
            long startTime = System.currentTimeMillis();
            if (this._secureXmlRpcClient != null) {
                block11: {
                    try {
                        logger.debug("Calling secure method: {} (parameters suppressed)", (Object)method);
                        result = this._secureXmlRpcClient.execute(method, parameters);
                        hasCalled = true;
                    }
                    catch (Exception e) {
                        logger.debug("Unable to call secure method.", (Throwable)e);
                        if (!this._requireSSLWhenRequested && this._xmlRpcClient != null) break block11;
                        if (e instanceof SSLHandshakeException) {
                            throw new ApplicationException("Unable to establish secure connection to server.\n\nEnsure you have an official SSL certificate installed on the server and are using a matching DNS name in config.properties to connect to the server.\n\n" + e.getMessage(), (Throwable)e);
                        }
                        throw new ApplicationException("Unable to establish secure connection to server: " + e.getMessage(), (Throwable)e);
                    }
                }
                if (result == null) {
                    throw new ApplicationException("Unable to successfully retrieve valid data from secure connection to server.");
                }
            }
            if (!hasCalled) {
                logger.debug("Calling method: {} (parameters suppressed)", (Object)method);
                result = this._xmlRpcClient.execute(method, parameters);
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Call to method: {} took {} ms. Result: {}", new Object[]{method, System.currentTimeMillis() - startTime, ServerConnection.resultToString(result)});
            }
            if (result instanceof XmlRpcException) {
                throw (XmlRpcException)((Object)result);
            }
            return result;
        }
        catch (XmlRpcException e) {
            throw new ServerConnectionException(e.getMessage() + " Method: " + method + " Params: (parameters suppressed)", e);
        }
        catch (IOException e) {
            this._ipAddressCacheExpiryTime = 0L;
            throw new ServerConnectionException("Problem communicating with server: " + e.getMessage(), e);
        }
    }

    private static String resultToString(Object result) {
        Object resultStr = null;
        if (result instanceof Collection) {
            Collection c = (Collection)result;
            if (c.size() > 50) {
                resultStr = "[not displayed, too large: " + c.size() + "]";
            }
        } else if (result instanceof Map) {
            Map c = (Map)result;
            if (c.size() > 50) {
                resultStr = "[not displayed, too large: " + c.size() + "]";
            }
        } else if (result instanceof byte[]) {
            resultStr = "[byte array length " + ((byte[])result).length + "]";
        }
        if (resultStr == null) {
            resultStr = String.valueOf(result);
        }
        return resultStr;
    }

    String getConnectionName() {
        if (!this._connected) {
            throw new ApplicationException("It is only valid to call this method on an open connection");
        }
        if (this._useIP) {
            return this._serverIP;
        }
        return this._serverName;
    }

    int getConnectionPort() {
        if (!this._connected) {
            throw new ApplicationException("It is only valid to call this method on an open connection");
        }
        return this._serverPort;
    }

    private synchronized String getMachineName() {
        return this._machineName;
    }

    private synchronized String getUserName() {
        return this._userName;
    }

    synchronized void setUserName(String userName) {
        this._userName = userName;
    }

    private void setSessionToken(String sessionToken) {
        this._sessionToken = sessionToken;
    }

    private synchronized String getSessionToken() {
        return this._sessionToken;
    }

    private synchronized String getAllIpAddresses() {
        return this._allIpAddresses;
    }

    private String attachScopeIDIfNeeded(String serverIP) {
        if (SystemUtils.IS_OS_MAC_OSX && NetworkUtils.isIpV6Address((String)serverIP) && !serverIP.contains("%")) {
            try (Socket ignored = new Socket(serverIP, this._serverPort);){
                logger.debug("Connected to: {}:{}", (Object)serverIP, (Object)this._serverPort);
            }
            catch (NoRouteToHostException e) {
                logger.debug("Detected MacOS jre ipv6 bug: scope-id probably required to reach server address {}", (Object)serverIP);
                Enumeration<NetworkInterface> theInterfaces = NetworkInterface.getNetworkInterfaces();
                while (true) {
                    String string;
                    if (!theInterfaces.hasMoreElements()) break;
                    NetworkInterface ni = theInterfaces.nextElement();
                    if (!ni.getName().startsWith("en")) continue;
                    String scopeID = "%" + ni.getIndex();
                    Socket ignored2 = new Socket(serverIP + scopeID, this._serverPort);
                    try {
                        logger.debug("Connected to: {}{}:{}", new Object[]{serverIP, scopeID, this._serverPort});
                        string = serverIP + scopeID;
                    }
                    catch (Throwable throwable) {
                        try {
                            try {
                                try {
                                    ignored2.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                throw throwable;
                            }
                            catch (Exception exception) {
                                continue;
                            }
                        }
                        catch (SocketException e2) {
                            logger.error("Unable to get network interfaces: {}", (Object)e2.getMessage());
                        }
                    }
                    ignored2.close();
                    return string;
                    break;
                }
            }
            catch (UnknownHostException e) {
                logger.debug("Host {} could not be resolved", (Object)serverIP);
            }
            catch (IOException e) {
                logger.debug("Unexpected IO error opening socket to {}", (Object)serverIP, (Object)e);
            }
        }
        return serverIP;
    }

    private ClientAuthResponse createClientAuthResponse(Hashtable<String, Object> result) {
        ClientAuthResponse response = new ClientAuthResponse(result);
        this.setSessionToken(response.getSessionToken());
        return response;
    }

    static class ServerConnectionException
    extends ApplicationException {
        private static final long serialVersionUID = -8421842186852051679L;

        ServerConnectionException(String message) {
            super(message);
        }

        ServerConnectionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

