/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit.accounts;

import biz.papercut.pcng.client.uit.accounts.AccountIdListModel;
import biz.papercut.pcng.common.ClientAccount;
import biz.papercut.pcng.util.Messages;
import biz.papercut.pcng.util.swing.EnhancedTextField;
import biz.papercut.pcng.util.swing.EnterFilteringInputMap;
import com.google.common.base.Stopwatch;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.TimeUnit;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountList
extends JPanel
implements FocusListener {
    private static final Logger logger = LoggerFactory.getLogger(AccountList.class);
    protected static final int COL_IDX_ACCOUNT = 0;
    protected static final int COL_IDX_CODE = 1;
    protected static final int COL_IDX_PREFERRED = 2;
    private static final String INDENT_SPACE = "    ";
    private static final int MAX_QUICK_FIND_LENGTH = 255;
    private static final int PREF_WIDTH = 400;
    private static final int COL_MIN_WIDTH_ACCOUNT = 100;
    private static final int COL_MAX_WIDTH_ACCOUNT = 400;
    private static final int COL_MIN_WIDTH_CODE = 100;
    private static final int COL_MAX_WIDTH_CODE = 133;
    private static final int COL_WIDTH_PREFERRED = 80;
    private static String s_lastSearch = "";
    private static boolean s_rememberLastSearch = true;
    private static long s_lastSelection = -1L;
    private final JTable _table;
    private final AccountListTableModel _tableModel;
    private JTextField _quickFind;
    private JCheckBox _rememberSearch;
    private boolean _dataLoaded;
    private final boolean _showCode;

    public AccountList(boolean showCode) {
        this._showCode = showCode;
        this._tableModel = new AccountListTableModel();
        this._table = new JTable(this._tableModel);
        EnterFilteringInputMap.applyToComponent((JComponent)this._table);
        this._quickFind = this.getQuickFindTextField();
        this._rememberSearch = this.getRememberSearchComboBox();
        this.layoutComponents();
        this._rememberSearch.setSelected(s_rememberLastSearch);
        if (this._rememberSearch.isSelected()) {
            this._quickFind.setText(s_lastSearch);
        }
        this._table.getSelectionModel().addListSelectionListener(e -> {
            ClientAccount a = this.getSelectedAccount();
            if (a != null && !a.isDisabled()) {
                s_lastSelection = a.getAccountId();
            }
        });
        if (!this._showCode) {
            TableColumnModel colModel = this._table.getColumnModel();
            colModel.removeColumn(colModel.getColumn(1));
        }
        this.addFocusListener(this);
        this.setFocusable(true);
    }

    public void loadData(List<ClientAccount> accounts, AccountIdListModel preferredAccounts) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this._tableModel.loadData(accounts, preferredAccounts, this._quickFind.getText());
        this.selectLastSelectedAccount();
        this._dataLoaded = true;
        logger.debug("Loading {} accounts in AccountList took {} ms", (Object)accounts.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    private void layoutComponents() {
        this._table.setPreferredScrollableViewportSize(new Dimension(400, 50));
        this._table.setShowVerticalLines(false);
        this._table.setShowHorizontalLines(false);
        this._table.setSelectionMode(0);
        this.initColumnSizes(this._table);
        DefaultTableCellRenderer accountRenderer = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                super.setValue(value);
                if (value instanceof ClientAccount) {
                    ClientAccount ca = (ClientAccount)value;
                    this.setEnabled(!ca.isDisabled());
                    if (ca.isParent()) {
                        this.setText(ca.getParentName());
                    } else {
                        this.setText(AccountList.INDENT_SPACE + ca.getSubName());
                    }
                }
            }
        };
        TableColumn accountCol = this._table.getColumn(Messages.getString(this.getClass(), (String)"Common.HEADING_ACCOUNT", (String[])new String[0]));
        accountCol.setCellRenderer(accountRenderer);
        JScrollPane scrollPane = new JScrollPane(this._table);
        scrollPane.getViewport().setBackground(this._table.getBackground());
        scrollPane.setOpaque(false);
        this._rememberSearch.setOpaque(false);
        FormLayout layout = new FormLayout("pref, 4dlu, pref:grow, 4dlu, pref", "pref, 4dlu, pref:grow");
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        CellConstraints cc = new CellConstraints();
        builder.setBorder(Borders.createEmptyBorder((String)"4dlu, 4dlu, 4dlu, 4dlu"));
        builder.addLabel(Messages.getString(this.getClass(), (String)"AccountList.SEARCH", (String[])new String[0]), cc.xy(1, 1));
        builder.add((Component)this._quickFind, cc.xy(3, 1));
        builder.add((Component)this._rememberSearch, cc.xy(5, 1));
        builder.add((Component)scrollPane, cc.xyw(1, 3, 5, CellConstraints.FILL, CellConstraints.FILL));
    }

    private void selectLastSelectedAccount() {
        AccountListTableModel model = (AccountListTableModel)this._table.getModel();
        int rowCount = model.getRowCount();
        if (rowCount < 1) {
            return;
        }
        if (s_lastSelection > 0L) {
            for (int i = 0; i < rowCount; ++i) {
                ClientAccount ca = (ClientAccount)model.getValueAt(i, 0);
                if (ca == null || ca.getAccountId() != s_lastSelection) continue;
                this._table.changeSelection(i, 0, false, false);
                return;
            }
        }
        this.selectBestMatchingAccount(this._quickFind.getText());
    }

    public void selectPersonalAccount() {
        s_lastSelection = -1L;
        this.selectLastSelectedAccount();
    }

    public void selectAccountByName(String name) {
        logger.debug("Attempting to pre-select account by name: {}", (Object)name);
        AccountListTableModel model = (AccountListTableModel)this._table.getModel();
        int rowCount = model.getRowCount();
        if (rowCount < 1) {
            return;
        }
        if (StringUtils.isNotBlank((String)name)) {
            for (int i = 0; i < rowCount; ++i) {
                ClientAccount ca = (ClientAccount)model.getValueAt(i, 0);
                if (ca == null || !ca.getDisplayName().equals(name)) continue;
                logger.debug("Found matching account, and will preselect");
                this._table.changeSelection(i, 0, false, false);
                return;
            }
        }
    }

    private void selectBestMatchingAccount(String filter) {
        int MAX_SCAN = 25;
        int firstActive = -1;
        int firstMatch = -1;
        int firstLeadingMatch = -1;
        filter = StringUtils.trimToEmpty((String)filter).toLowerCase();
        AccountListTableModel model = (AccountListTableModel)this._table.getModel();
        if (model.getRowCount() < 1) {
            return;
        }
        int max = model.getRowCount() > 25 ? 25 : model.getRowCount();
        for (int i = 0; i < max; ++i) {
            ClientAccount ca = (ClientAccount)model.getValueAt(i, 0);
            if (ca == null || ca.isDisabled()) continue;
            if (firstActive == -1) {
                firstActive = i;
            }
            if (firstMatch == -1 && this.accountMatchesFilter(ca, filter, false)) {
                firstMatch = i;
            }
            if (!this.accountMatchesFilter(ca, filter, true)) continue;
            firstLeadingMatch = i;
            break;
        }
        if (firstLeadingMatch >= 0) {
            this._table.changeSelection(firstLeadingMatch, 0, false, false);
        } else if (firstMatch >= 0) {
            this._table.changeSelection(firstMatch, 0, false, false);
        } else {
            this._table.changeSelection(Math.max(firstActive, 0), 0, false, false);
        }
    }

    private boolean accountMatchesFilter(ClientAccount ca, String filter, boolean leadingOnly) {
        if (ca == null) {
            return false;
        }
        if (leadingOnly) {
            return ca.getParentName().toLowerCase().startsWith(filter) || ca.getSubName().toLowerCase().startsWith(filter) || ca.getFullPin().toLowerCase().startsWith(filter);
        }
        return ca.getParentName().toLowerCase().contains(filter) || ca.getSubName().toLowerCase().contains(filter) || ca.getFullPin().toLowerCase().contains(filter);
    }

    public ClientAccount getSelectedAccount() {
        AccountListTableModel model = (AccountListTableModel)this._table.getModel();
        int row = this._table.getSelectedRow();
        if (row >= 0) {
            return (ClientAccount)model.getValueAt(row, 0);
        }
        return null;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this._table.getSelectionModel().addListSelectionListener(listener);
    }

    public void initColumnSizes(JTable table) {
        table.getColumnModel().getColumn(0).setMinWidth(100);
        table.getColumnModel().getColumn(0).setMaxWidth(400);
        if (this._showCode) {
            table.getColumnModel().getColumn(1).setMinWidth(100);
            table.getColumnModel().getColumn(1).setMaxWidth(133);
        } else {
            table.getColumnModel().getColumn(1).setMinWidth(0);
            table.getColumnModel().getColumn(1).setMaxWidth(0);
        }
        table.getColumnModel().getColumn(2).setMinWidth(80);
        table.getColumnModel().getColumn(2).setMaxWidth(80);
        table.getColumnModel().getColumn(2).setResizable(false);
    }

    private JCheckBox getRememberSearchComboBox() {
        if (this._rememberSearch == null) {
            this._rememberSearch = new JCheckBox(Messages.getString(this.getClass(), (String)"AccountList.REMEMBER", (String[])new String[0]));
            this._rememberSearch.setSelected(s_rememberLastSearch);
            this._rememberSearch.addChangeListener(e -> {
                s_rememberLastSearch = this._rememberSearch.isSelected();
            });
        }
        return this._rememberSearch;
    }

    private JTextField getQuickFindTextField() {
        if (this._quickFind == null) {
            this._quickFind = new EnhancedTextField(255);
            DocumentListener documentListener = new DocumentListener(){
                final Timer _searchDelayTimer = new Timer();
                TimerTask _searchTask;

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.doChange(e);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.doChange(e);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.doChange(e);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void doChange(DocumentEvent e) {
                    if (!AccountList.this._dataLoaded) {
                        return;
                    }
                    AccountList accountList = AccountList.this;
                    synchronized (accountList) {
                        if (this._searchTask != null) {
                            this._searchTask.cancel();
                            this._searchTask = null;
                        }
                        this._searchTask = new TimerTask(){

                            @Override
                            public void run() {
                                SwingUtilities.invokeLater(() -> {
                                    TableModel model = AccountList.this._table.getModel();
                                    if (model instanceof AccountListTableModel) {
                                        ((AccountListTableModel)model).applyFilter(AccountList.this._quickFind.getText());
                                        AccountList.this.selectBestMatchingAccount(AccountList.this._quickFind.getText());
                                    }
                                    s_lastSearch = AccountList.this._quickFind.getText();
                                    AccountList accountList = AccountList.this;
                                    synchronized (accountList) {
                                        _searchTask = null;
                                    }
                                });
                            }
                        };
                        this._searchDelayTimer.schedule(this._searchTask, 500L);
                    }
                }
            };
            this._quickFind.getDocument().addDocumentListener(documentListener);
        }
        return this._quickFind;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this._quickFind.requestFocusInWindow();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    public void dispose() {
        this._tableModel.dispose();
    }

    public static class AccountListTableModel
    extends AbstractTableModel {
        private static final Logger logger = LoggerFactory.getLogger(AccountListTableModel.class);
        private static final long serialVersionUID = 2767330028350011996L;
        private List<ClientAccount> _allAccounts;
        private List<ClientAccount> _displayedAccounts;
        private final List<ClientAccount> _filteredAccounts = new ArrayList<ClientAccount>();
        private AccountIdListModel _preferredAccounts;

        public AccountListTableModel() {
            ClientAccount ca = new ClientAccount(1L);
            ca.setDisabled(true);
            ca.setParentName(Messages.getString(this.getClass(), (String)"Common.LOADING", (String[])new String[0]));
            this._displayedAccounts = new ArrayList<ClientAccount>(1);
            this._displayedAccounts.add(ca);
            this._preferredAccounts = new AccountIdListModel("");
        }

        public void dispose() {
            this._allAccounts = new ArrayList<ClientAccount>();
            this._displayedAccounts = this._allAccounts;
            this._filteredAccounts.clear();
        }

        public void loadData(List<ClientAccount> accounts, AccountIdListModel preferredAccounts, String initialFilter) {
            this._allAccounts = accounts;
            this.sortAccounts(this._allAccounts);
            String currentParent = "";
            ArrayList<ClientAccount> placeHolderParents = new ArrayList<ClientAccount>();
            for (ClientAccount ca : this._allAccounts) {
                if (ca.isParent()) {
                    currentParent = ca.getParentName();
                    continue;
                }
                if (ca.getParentName().equals(currentParent)) continue;
                ClientAccount placeHolder = new ClientAccount(-9999L);
                placeHolder.setDisabled(true);
                placeHolder.setParentName(ca.getParentName());
                placeHolder.setSubName("");
                placeHolderParents.add(placeHolder);
                currentParent = ca.getParentName();
            }
            if (!placeHolderParents.isEmpty()) {
                logger.debug("Added {} place holder parent account. Resorting.", (Object)placeHolderParents.size());
                this._allAccounts.addAll(placeHolderParents);
                this.sortAccounts(this._allAccounts);
            }
            this._preferredAccounts = preferredAccounts;
            this.buildFilteredAccounts(initialFilter);
            this.fireTableDataChanged();
        }

        private void sortAccounts(List<ClientAccount> accounts) {
            Stopwatch stopwatch = Stopwatch.createStarted();
            accounts.sort((c1, c2) -> {
                if (c1.getAccountId() == -1L) {
                    return -1;
                }
                if (c2.getAccountId() == -1L) {
                    return 1;
                }
                int r = c1.getParentName().compareToIgnoreCase(c2.getParentName());
                if (r == 0) {
                    r = c1.getSubName().compareToIgnoreCase(c2.getSubName());
                }
                return r;
            });
            logger.debug("Sorting {} accounts took {} ms", (Object)accounts.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString(this.getClass(), (String)"Common.HEADING_ACCOUNT", (String[])new String[0]);
            }
            if (column == 1) {
                return Messages.getString(this.getClass(), (String)"Common.HEADING_CODE", (String[])new String[0]);
            }
            if (column == 2) {
                return Messages.getString(this.getClass(), (String)"Common.HEADING_PREFERRED", (String[])new String[0]);
            }
            throw new IllegalArgumentException("Unexpected column index");
        }

        public void applyFilter(String filter) {
            this.buildFilteredAccounts(filter);
            this.fireTableDataChanged();
        }

        private void buildFilteredAccounts(String filter) {
            if (this._allAccounts == null) {
                return;
            }
            Stopwatch stopwatch = Stopwatch.createStarted();
            logger.debug("Filter: {}", (Object)filter);
            ClientAccount currentParent = null;
            boolean currentParentMatched = true;
            String filterLC = StringUtils.trimToEmpty((String)filter).toLowerCase();
            this._filteredAccounts.clear();
            if (StringUtils.isEmpty((String)filterLC)) {
                this._displayedAccounts = this._allAccounts;
            } else {
                for (ClientAccount ca : this._allAccounts) {
                    if (ca.isParent()) {
                        currentParent = ca;
                        if (this.accountMatchesFilter(ca, filterLC)) {
                            this._filteredAccounts.add(ca);
                            currentParentMatched = true;
                            continue;
                        }
                        currentParentMatched = false;
                        continue;
                    }
                    if (currentParentMatched) {
                        this._filteredAccounts.add(ca);
                        continue;
                    }
                    if (!this.accountMatchesFilter(ca, filterLC)) continue;
                    if (currentParent != null) {
                        this._filteredAccounts.add(currentParent);
                        currentParent = null;
                    }
                    this._filteredAccounts.add(ca);
                }
                this._displayedAccounts = this._filteredAccounts;
            }
            logger.debug("Filter '{}' took: {} ms", (Object)filter, (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        }

        private boolean accountMatchesFilter(ClientAccount ca, String filter) {
            return ca.getParentName().toLowerCase().contains(filter) || ca.getSubName().toLowerCase().contains(filter) || ca.getFullPin().toLowerCase().contains(filter);
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            if (this._displayedAccounts == null) {
                return 1;
            }
            return this._displayedAccounts.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                if (this._displayedAccounts == null) {
                    return Messages.getString(this.getClass(), (String)"Common.LOADING", (String[])new String[0]);
                }
                return this._displayedAccounts.get(rowIndex);
            }
            if (columnIndex == 1) {
                if (this._displayedAccounts == null) {
                    return "";
                }
                ClientAccount ca = this._displayedAccounts.get(rowIndex);
                return ca.getFullPin();
            }
            if (columnIndex == 2) {
                if (this._displayedAccounts == null) {
                    return false;
                }
                Long accountID = this._displayedAccounts.get(rowIndex).getAccountId();
                return this._preferredAccounts.contains(accountID);
            }
            throw new IllegalArgumentException("unexpected column index");
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            if (this._displayedAccounts == null) {
                return;
            }
            if (col == 2) {
                Long accountID = this._displayedAccounts.get(row).getAccountId();
                if (((Boolean)value).booleanValue()) {
                    if (!this._preferredAccounts.contains(accountID)) {
                        this._preferredAccounts.add(accountID);
                    }
                } else if (this._preferredAccounts.contains(accountID)) {
                    this._preferredAccounts.remove(accountID);
                }
                this.fireTableCellUpdated(row, col);
            }
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col == 2 && !this._displayedAccounts.get(row).isDisabled();
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }
    }
}

