/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.ConfigFile;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;

public enum ApplicationMode {
    Development{

        @Override
        Properties getBrandProperties() throws IOException {
            return ApplicationMode.loadDevBrandProperties(ApplicationMode.getDevServerDir());
        }
    }
    ,
    Production{

        @Override
        Properties getBrandProperties() {
            return new Properties();
        }
    };

    private static final String DEV_HOME;
    private static final String SERVER_HOME;
    private static final String BRAND_PROPERTIES = "brand.properties";
    private static final String DEFAULT_BRAND = "papercut";

    abstract Properties getBrandProperties() throws IOException;

    static ApplicationMode detect() {
        Path baseName = Paths.get(".", new String[0]);
        if (StringUtils.isNotBlank((String)SERVER_HOME)) {
            Path serverHome = Paths.get(SERVER_HOME, new String[0]);
            baseName = serverHome.subpath(serverHome.getNameCount() - 1, serverHome.getNameCount());
        }
        if (StringUtils.isNotBlank((String)DEV_HOME) || StringUtils.trimToEmpty((String)baseName.toString()).matches("working.*")) {
            return Development;
        }
        return Production;
    }

    private static String getDevServerDir() {
        if (StringUtils.isNotBlank((String)DEV_HOME)) {
            return new File(DEV_HOME + "/server").getAbsolutePath();
        }
        return new File(SERVER_HOME).getAbsoluteFile().getParent();
    }

    private static Properties loadDevBrandProperties(String serverDir, String brand) throws IOException {
        String brandProperties = FilenameUtils.concat((String)serverDir, (String)("../build/brands/" + brand + "/brand.properties"));
        Properties brandProps = ConfigFile.load(brandProperties);
        Preconditions.checkState((!brandProps.isEmpty() ? 1 : 0) != 0, (String)"Unable to load %s", (Object)brandProperties);
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)brandProps);
        return properties;
    }

    private static String getBrand(String devHome) {
        String brandProperties = FilenameUtils.concat((String)devHome, (String)"../brand.properties");
        try {
            Properties properties = ConfigFile.load(brandProperties);
            return properties.getProperty("brand", DEFAULT_BRAND);
        }
        catch (IOException e) {
            return DEFAULT_BRAND;
        }
    }

    boolean isDevelopment() {
        return Development.equals((Object)this);
    }

    private static Properties loadDevBrandProperties(String serverDir) throws IOException {
        String brand = ApplicationMode.getBrand(serverDir);
        return ApplicationMode.loadDevBrandProperties(serverDir, brand);
    }

    static {
        DEV_HOME = System.getProperty("dev.home");
        SERVER_HOME = System.getProperty("server.home");
    }
}

