/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.ApplicationInfo;
import biz.papercut.pcng.util.Formatter;
import biz.papercut.pcng.util.NetworkUtils;
import java.io.File;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.lookup.Log4jLookup;

@Plugin(name="PcMfLogLookup", category="Lookup")
public class CustomLogFileHeader
extends Log4jLookup {
    private static final long START_TIME = System.currentTimeMillis();
    private static final String LINE_SEPARATOR = System.lineSeparator();

    private String dumpApplicationInfo() {
        StringBuilder sb = new StringBuilder(800);
        sb.append("# Application version: ").append(CustomLogFileHeader.getApplicationVersion());
        sb.append(System.lineSeparator());
        double maxMemoryMB = (double)Runtime.getRuntime().maxMemory() / 1024.0 / 1024.0;
        int availableProcessors = Runtime.getRuntime().availableProcessors();
        double freeSpaceMB = this.getFreeSpaceMB();
        long uptimeMillis = System.currentTimeMillis() - START_TIME;
        String uptime = this.toUptimeString(uptimeMillis);
        List<String> ipAddresses = NetworkUtils.getAllIpAddresses();
        sb.append("# System details: max memory: ").append(Formatter.formatNumber(maxMemoryMB, 1, Locale.US)).append(" MB").append(", processors: ").append(availableProcessors).append((String)(freeSpaceMB < 0.0 ? "" : ", free space: " + Formatter.formatNumber(freeSpaceMB, 1, Locale.US) + " MB")).append(", uptime: ").append(uptime).append(", hostname: ").append(NetworkUtils.getComputerName()).append(", IP addresses: ").append(ipAddresses).append((String)(ipAddresses.size() <= 1 ? "" : " (Primary: " + NetworkUtils.getIpAddress() + ")")).append(", runtime: ").append(System.getProperty("java.runtime.version")).append(", time-zone: ").append(TimeZone.getDefault().getID()).append(", calendar: ").append(Calendar.getInstance().getClass().getSimpleName()).append(", locale: ").append(Locale.getDefault()).append(", encoding: ").append(Charset.defaultCharset());
        sb.append(LINE_SEPARATOR);
        return sb.toString();
    }

    private static String getApplicationVersion() {
        try {
            return ApplicationInfo.getInstance().getDisplayVersionWithPlatformInfo();
        }
        catch (Exception e) {
            return "Unknown application version: " + String.valueOf(e);
        }
    }

    private String toUptimeString(long uptimeMillis) {
        if (uptimeMillis > 86400000L) {
            return Formatter.formatNumber((double)uptimeMillis / 8.64E7, 2, Locale.US) + " days";
        }
        if (uptimeMillis > 3600000L) {
            return Formatter.formatNumber((double)uptimeMillis / 3600000.0, 2, Locale.US) + " hours";
        }
        return Formatter.formatNumber((double)uptimeMillis / 60000.0, 2, Locale.US) + " minutes";
    }

    private double getFreeSpaceMB() {
        double freeSpaceMB = -1.0;
        try {
            File file = new File(URLDecoder.decode(this.configuration.getConfigurationSource().getURL().getPath(), StandardCharsets.UTF_8));
            long freeSpaceBytes = file.getFreeSpace();
            freeSpaceMB = freeSpaceBytes < 0L ? -1.0 : (double)freeSpaceBytes / 1024.0 / 1024.0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return freeSpaceMB;
    }

    private String dumpDateTime(String prefix) {
        return prefix + Formatter.formatCurrentDateTimeOfPattern("yyyy-MM-dd HH:mm:ss,S") + System.lineSeparator();
    }

    public String lookup(LogEvent event, String key) {
        return switch (key) {
            case "header" -> this.dumpApplicationInfo() + this.dumpDateTime("# Log opened at: ");
            case "footer" -> this.dumpDateTime("# Log closed at: ");
            default -> throw new IllegalArgumentException("Not a valid key: " + key);
        };
    }
}

