/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;

public final class DateTimeFormatterRegistry {
    private static final DateTimeFormatterRegistry INSTANCE = new DateTimeFormatterRegistry();
    private static final int CACHE_SIZE_LIMIT = 1000;
    private static final Cache<Key, DateTimeFormatter> formatterCache = CacheBuilder.newBuilder().maximumSize(1000L).build();

    private DateTimeFormatterRegistry() {
    }

    public static DateTimeFormatterRegistry getInstance() {
        return INSTANCE;
    }

    DateTimeFormatter getLocalizedDateTimeFormatter(FormatStyle dateFormatStyle, FormatStyle timeFormatStyle, Locale locale) {
        return DateTimeFormatterRegistry.loadFormatter("Date format style: " + String.valueOf((Object)dateFormatStyle) + "| Time format style: " + timeFormatStyle.name(), DateTimeFormatterRegistry.buildMapKey(KeyType.DATETIME_STYLE, dateFormatStyle.name() + "-" + timeFormatStyle.name(), locale), () -> DateTimeFormatter.ofLocalizedDateTime(dateFormatStyle, timeFormatStyle).withLocale(locale));
    }

    DateTimeFormatter getTimeOnlyFormatter(FormatStyle timeFormatStyle, Locale locale) {
        return DateTimeFormatterRegistry.loadFormatter("Time format style: " + timeFormatStyle.name(), DateTimeFormatterRegistry.buildMapKey(KeyType.TIME_ONLY, timeFormatStyle.name(), locale), () -> DateTimeFormatter.ofLocalizedTime(timeFormatStyle).withLocale(locale));
    }

    DateTimeFormatter getDateOnlyFormatter(FormatStyle dateFormatStyle, Locale locale) {
        return DateTimeFormatterRegistry.loadFormatter("Date format style: " + dateFormatStyle.name(), DateTimeFormatterRegistry.buildMapKey(KeyType.DATE_ONLY, dateFormatStyle.name(), locale), () -> DateTimeFormatter.ofLocalizedDate(dateFormatStyle).withLocale(locale));
    }

    DateTimeFormatter getPatternDateTimeFormatter(String pattern, Locale locale) {
        return DateTimeFormatterRegistry.loadFormatter(pattern, DateTimeFormatterRegistry.buildMapKey(KeyType.DATETIME_PATTERN, pattern, locale), () -> DateTimeFormatter.ofPattern(pattern, locale));
    }

    static DateTimeFormatter loadFormatter(String patternOrFormatStyleDesc, Key key, Callable<DateTimeFormatter> loader) {
        try {
            return (DateTimeFormatter)formatterCache.get((Object)key, loader);
        }
        catch (ExecutionException ex) {
            throw new RuntimeException("Failed to create datetime formatter for [" + patternOrFormatStyleDesc + "]", ex);
        }
    }

    static Key buildMapKey(KeyType keyType, String formatStyleOrPattern, Locale locale) {
        return new Key(keyType, formatStyleOrPattern, locale);
    }

    int size() {
        return Long.valueOf(formatterCache.size()).intValue();
    }

    void clear() {
        formatterCache.invalidateAll();
    }

    private static enum KeyType {
        DATETIME_STYLE,
        TIME_ONLY,
        DATE_ONLY,
        DATETIME_PATTERN;

    }

    private record Key(KeyType prefix, String formatStyleOrPattern, Locale locale) {
    }
}

