/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import biz.papercut.pcng.util.tuple.Pair;
import java.time.DayOfWeek;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Month;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.time.temporal.WeekFields;
import java.util.Calendar;
import java.util.Date;
import java.util.Set;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateUtils;

public final class DateTimeUtils {
    private DateTimeUtils() {
    }

    @Nullable
    public static Date getLastSecondOfDay(@Nullable Date date) {
        if (date == null) {
            return null;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c = DateUtils.truncate((Calendar)c, (int)5);
        c.add(5, 1);
        c.add(14, -1);
        date = c.getTime();
        return date;
    }

    public static Date truncateTime(Date date) {
        return DateUtils.truncate((Date)date, (int)5);
    }

    public static long millisBetween(Date later, Date earlier) {
        return later.getTime() - earlier.getTime();
    }

    public static int daysBetween(Date later, Date earlier) {
        return DateTimeUtils.daysBetween(later, earlier, false);
    }

    public static int daysBetweenDstAware(Date later, Date earlier) {
        return DateTimeUtils.daysBetween(later, earlier, true);
    }

    private static int daysBetween(Date later, Date earlier, boolean dstAware) {
        long addOffset = 0L;
        if (dstAware) {
            TimeZone timeZone = Calendar.getInstance().getTimeZone();
            addOffset = timeZone.getOffset(later.getTime()) - timeZone.getOffset(earlier.getTime());
        }
        return (int)((DateTimeUtils.millisBetween(later, earlier) + addOffset) / 86400000L);
    }

    public static int minutesBetween(Date later, Date earlier) {
        return (int)(DateTimeUtils.millisBetween(later, earlier) / 60000L);
    }

    public static long secondsBetween(ZonedDateTime later, ZonedDateTime earlier) {
        return ChronoUnit.SECONDS.between(earlier, later);
    }

    public static ZonedDateTime addSeconds(ZonedDateTime time, int seconds) {
        return time.plusSeconds(seconds);
    }

    public static Date addDays(Date date, int days) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(5, days);
        return c.getTime();
    }

    public static Date addMonth(Date date, int months) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, months);
        return c.getTime();
    }

    public static Date addYear(Date date, int years) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, years);
        return c.getTime();
    }

    public static Date addTimeToDate(Date date, @Nullable Date time) {
        if (time == null) {
            return date;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        Calendar timeCal = Calendar.getInstance();
        timeCal.setTime(time);
        c.set(11, timeCal.get(11));
        c.set(12, timeCal.get(12));
        c.set(13, timeCal.get(13));
        c.set(14, timeCal.get(14));
        return c.getTime();
    }

    public static boolean isDateSame(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(date1);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(date2);
        return c1.get(5) == c2.get(5) && c1.get(2) == c2.get(2) && c1.get(1) == c2.get(1);
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, 1);
        return DateTimeUtils.truncateTime(c.getTime());
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.set(5, c.getActualMaximum(5));
        return DateTimeUtils.truncateTime(c.getTime());
    }

    public static Date getStartOfYesterday(Date date) {
        Date d = new Date(date.getTime());
        return DateTimeUtils.truncateTime(DateTimeUtils.addDays(d, -1));
    }

    public static Date getEndOfYesterday(Date date) {
        Date d = new Date(date.getTime());
        return DateTimeUtils.getLastSecondOfDay(DateTimeUtils.addDays(d, -1));
    }

    public static LocalDateTime getStartDateOfLastWeek(LocalDate date, DayOfWeek fromDayOfWeek) {
        LocalDate start = DateTimeUtils.getDateWithDayOfWeek(date.minusWeeks(1L), fromDayOfWeek);
        LocalDate end = start.plusDays(6L);
        if (end.isBefore(date)) {
            return start.atStartOfDay();
        }
        return start.minusWeeks(1L).atStartOfDay();
    }

    public static LocalDateTime getEndDateOfLastWeek(LocalDate date, DayOfWeek fromDayOfWeek) {
        LocalDate start = DateTimeUtils.getDateWithDayOfWeek(date.minusWeeks(1L), fromDayOfWeek);
        LocalDate end = start.plusDays(6L);
        if (end.isBefore(date)) {
            return end.atTime(LocalTime.MAX);
        }
        return end.minusWeeks(1L).atTime(LocalTime.MAX);
    }

    public static LocalDateTime getStartDateOfLastFortnight(LocalDate date, DayOfWeek fromDayOfWeek) {
        LocalDate start = DateTimeUtils.getDateWithDayOfWeek(date.minusWeeks(2L), fromDayOfWeek);
        LocalDate endOfFortnight = start.plusWeeks(2L).minusDays(1L);
        if (endOfFortnight.isBefore(date)) {
            return start.atStartOfDay();
        }
        return start.minusWeeks(1L).atStartOfDay();
    }

    public static LocalDateTime getEndDateOfLastFortnight(LocalDate date, DayOfWeek fromDayOfWeek) {
        LocalDate start = DateTimeUtils.getDateWithDayOfWeek(date.minusWeeks(2L), fromDayOfWeek);
        LocalDate endOfFortnight = start.plusWeeks(2L).minusDays(1L);
        if (endOfFortnight.isBefore(date)) {
            return endOfFortnight.atTime(LocalTime.MAX);
        }
        return endOfFortnight.minusWeeks(1L).atTime(LocalTime.MAX);
    }

    public static Date getStartOfLastMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, -1);
        c.set(5, 1);
        return DateTimeUtils.truncateTime(c.getTime());
    }

    public static Date getStartOfLastYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, -1);
        c.set(2, 0);
        c.set(5, 1);
        return DateTimeUtils.truncateTime(c.getTime());
    }

    public static LocalDateTime getStartOfLastQuarter(LocalDate date, Month startMonthOfQuarter) {
        return DateTimeUtils.getLastQuarterDateRange(date, startMonthOfQuarter).get0().atStartOfDay();
    }

    private static Pair<LocalDate, LocalDate> getLastQuarterDateRange(LocalDate date, Month startMonthOfQuarter) {
        LocalDate quarterEndDate;
        LocalDate quarterStartDate;
        Month currentMonth = date.getMonth();
        if (currentMonth == startMonthOfQuarter || currentMonth == startMonthOfQuarter.plus(1L) || currentMonth == startMonthOfQuarter.plus(2L)) {
            quarterStartDate = date.with(startMonthOfQuarter).with(TemporalAdjusters.firstDayOfMonth());
            quarterEndDate = date.with(startMonthOfQuarter.plus(2L)).with(TemporalAdjusters.lastDayOfMonth());
        } else if (currentMonth == startMonthOfQuarter.plus(3L) || currentMonth == startMonthOfQuarter.plus(4L) || currentMonth == startMonthOfQuarter.plus(5L)) {
            quarterStartDate = date.with(startMonthOfQuarter.plus(3L)).with(TemporalAdjusters.firstDayOfMonth());
            quarterEndDate = date.with(startMonthOfQuarter.plus(5L)).with(TemporalAdjusters.lastDayOfMonth());
        } else if (currentMonth == startMonthOfQuarter.plus(6L) || currentMonth == startMonthOfQuarter.plus(7L) || currentMonth == startMonthOfQuarter.plus(8L)) {
            quarterStartDate = date.with(startMonthOfQuarter.plus(6L)).with(TemporalAdjusters.firstDayOfMonth());
            quarterEndDate = date.with(startMonthOfQuarter.plus(8L)).with(TemporalAdjusters.lastDayOfMonth());
        } else {
            quarterStartDate = date.with(startMonthOfQuarter.plus(9L)).with(TemporalAdjusters.firstDayOfMonth());
            quarterEndDate = date.with(startMonthOfQuarter.plus(11L)).with(TemporalAdjusters.lastDayOfMonth());
        }
        if (quarterEndDate.isBefore(date)) {
            quarterEndDate = quarterEndDate.plusYears(1L);
        }
        if (quarterStartDate.isAfter(date)) {
            quarterStartDate = quarterStartDate.minusYears(1L);
        }
        if (quarterEndDate.isAfter(date)) {
            quarterStartDate = quarterStartDate.minusMonths(3L).with(TemporalAdjusters.firstDayOfMonth());
            quarterEndDate = quarterEndDate.minusMonths(3L).with(TemporalAdjusters.lastDayOfMonth());
        }
        return Pair.from(quarterStartDate, quarterEndDate);
    }

    public static LocalDateTime getEndOfLastQuarter(LocalDate date, Month startMonthOfQuarter) {
        return DateTimeUtils.getLastQuarterDateRange(date, startMonthOfQuarter).get1().atTime(LocalTime.MAX);
    }

    public static Date getEndOfLastYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(1, -1);
        c.set(2, 11);
        c.set(5, 31);
        return DateTimeUtils.getLastSecondOfDay(c.getTime());
    }

    public static boolean isFirstDayOfYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return DateTimeUtils.isFirstDayOfMonth(date) && c.get(2) == 0;
    }

    public static boolean isFirstDayOfAnnualQuarter(LocalDate date, Month startMonthOfQuarter) {
        Month currentMonth = date.getMonth();
        boolean isMonthOfQuarter = currentMonth == startMonthOfQuarter || currentMonth == startMonthOfQuarter.plus(3L) || currentMonth == startMonthOfQuarter.plus(6L) || currentMonth == startMonthOfQuarter.plus(9L);
        return date.getDayOfMonth() == 1 && isMonthOfQuarter;
    }

    public static Date getLastSecondOfLastMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        c.add(2, -1);
        c.set(5, c.getActualMaximum(5));
        return DateTimeUtils.getLastSecondOfDay(c.getTime());
    }

    public static boolean isFirstDayOfWeek(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(7) == 1;
    }

    public static boolean isFirstDayOfFortnight(Date date) {
        return DateTimeUtils.isFirstDayOfWeek(date) && DateTimeUtils.isFortnightWeekOfYear(date);
    }

    public static boolean isFortnightWeekOfYear(Date date) {
        return DateTimeUtils.asLocalDate(date).get(WeekFields.SUNDAY_START.weekOfYear()) % 2 == 0;
    }

    public static boolean isFirstDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5) == 1;
    }

    public static int getDayOfMonth(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(5);
    }

    public static int getDayOfYear(Date date) {
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        return c.get(6);
    }

    public static Date asDateTime(LocalDateTime dateTime) {
        return Date.from(dateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date asDate(LocalDate date) {
        return Date.from(date.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate asLocalDate(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDate getFirstDayOfWeek(LocalDate date) {
        DayOfWeek dayOfWeek = date.getDayOfWeek();
        if (dayOfWeek != DayOfWeek.SUNDAY) {
            date = date.minusDays(dayOfWeek.getValue());
        }
        return date;
    }

    public static DayOfWeek dayOfWeek(int dayOfWeek) {
        return DayOfWeek.SUNDAY.plus(dayOfWeek - 1);
    }

    public static DayOfWeek getDayOfWeek(Date date) {
        return date.toInstant().atZone(ZoneId.systemDefault()).getDayOfWeek();
    }

    public static LocalDate getNextWeekWithDayOfWeek(LocalDate date, DayOfWeek dayOfWeek) {
        date = date.plusWeeks(1L);
        return date.with(WeekFields.SUNDAY_START.dayOfWeek(), dayOfWeek.get(WeekFields.SUNDAY_START.dayOfWeek()));
    }

    public static LocalDate getNextFortnightWeekWithDayOfWeek(LocalDate date, DayOfWeek dayOfWeek) {
        if (DateTimeUtils.isFortnightWeekOfYear(DateTimeUtils.asDate(date))) {
            date = date.plusWeeks(1L);
            date = DateTimeUtils.getNextWeekWithDayOfWeek(date, dayOfWeek);
        } else {
            date = DateTimeUtils.getNextWeekWithDayOfWeek(date, dayOfWeek);
        }
        return date;
    }

    public static LocalDate getNextMonthDateFromDay(LocalDate date, int dayOfMonth) {
        date = date.plusMonths(1L);
        return date.withDayOfMonth(dayOfMonth);
    }

    public static LocalDate getFirstDateOfNextQuarter(LocalDate date, Month startMonthOfQuarter) {
        LocalDate firstDateOfNextQuarter = DateTimeUtils.getEndOfLastQuarter(date, startMonthOfQuarter).toLocalDate().plusDays(1L);
        if (firstDateOfNextQuarter.isBefore(date)) {
            firstDateOfNextQuarter = firstDateOfNextQuarter.plusMonths(3L);
        }
        return firstDateOfNextQuarter;
    }

    public static LocalDate getNextYearDateFromDay(LocalDate date, int day) {
        date = date.plusYears(1L);
        date = date.withDayOfYear(day);
        return date;
    }

    public static Pair<Date, Date> getLastMonthPeriod(Date date, int dayOfMonth) {
        Date toDate;
        Date fromDate;
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        if (dayOfMonth < 1 || dayOfMonth > 28) {
            dayOfMonth = 1;
        }
        if (dayOfMonth <= Calendar.getInstance().get(5)) {
            c.add(2, -1);
            c.set(5, dayOfMonth);
            fromDate = DateTimeUtils.truncateTime(c.getTime());
            c.setTime(date);
            c.set(5, dayOfMonth - 1);
            toDate = DateTimeUtils.getLastSecondOfDay(c.getTime());
        } else {
            c.add(2, -2);
            c.set(5, dayOfMonth);
            fromDate = DateTimeUtils.truncateTime(c.getTime());
            c.setTime(date);
            c.add(2, -1);
            c.set(5, dayOfMonth - 1);
            toDate = DateTimeUtils.getLastSecondOfDay(c.getTime());
        }
        return Pair.from(fromDate, toDate);
    }

    public static SortedSet<Date> csvToSet(String dateCSV) throws IllegalArgumentException {
        if (StringUtils.isBlank((String)dateCSV)) {
            throw new IllegalArgumentException("CSV date input was blank");
        }
        TreeSet<Date> dates = new TreeSet<Date>();
        Pattern full = Pattern.compile("^(\\d{4})-(\\d{1,2})-(\\d{1,2})$");
        Pattern partialMonthAndDayOnly = Pattern.compile("^(?:\\*{1,4}-)?(\\d{1,2})-(\\d{1,2})$");
        Pattern partialDayOnly = Pattern.compile("^(?:\\*{1,4}-\\*{1,2}-)?(\\d{1,2})$");
        boolean monthIsWildcard = false;
        boolean yearIsWildcard = false;
        try {
            for (String date : dateCSV.split(",")) {
                date = date.trim();
                Calendar c = Calendar.getInstance();
                int yVal = c.get(1);
                int mVal = c.get(2);
                int dVal = c.get(5);
                boolean hasMatched = false;
                Matcher m = full.matcher(date);
                if (m.matches()) {
                    yVal = Integer.parseInt(m.group(1));
                    mVal = Integer.parseInt(m.group(2)) - 1;
                    dVal = Integer.parseInt(m.group(3));
                    hasMatched = true;
                }
                if (!hasMatched && (m = partialMonthAndDayOnly.matcher(date)).matches()) {
                    mVal = Integer.parseInt(m.group(1)) - 1;
                    dVal = Integer.parseInt(m.group(2));
                    hasMatched = true;
                    yearIsWildcard = true;
                }
                if (!hasMatched && (m = partialDayOnly.matcher(date)).matches()) {
                    dVal = Integer.parseInt(m.group(1));
                    hasMatched = true;
                    yearIsWildcard = true;
                    monthIsWildcard = true;
                }
                if (!hasMatched) {
                    throw new IllegalArgumentException("Invalid date format: " + date);
                }
                if (mVal < 0 || mVal > 11) {
                    throw new IllegalArgumentException("Invalid month: " + mVal);
                }
                if (dVal < 1 || dVal > 31) {
                    throw new IllegalArgumentException("Invalid day of month: " + dVal);
                }
                c.set(1, yVal);
                c.set(2, mVal);
                c.set(5, dVal);
                Date dateOnly = DateTimeUtils.truncateTime(c.getTime());
                if (dateOnly.before(DateTimeUtils.truncateTime(new Date()))) {
                    if (monthIsWildcard) {
                        c.add(2, 1);
                    } else if (yearIsWildcard) {
                        c.add(1, 1);
                    }
                }
                dates.add(DateTimeUtils.truncateTime(c.getTime()));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Unable to parse CSV date: " + e.getMessage(), e);
        }
        return dates;
    }

    public static boolean isToday(Date date) {
        Calendar today = Calendar.getInstance();
        Calendar d = Calendar.getInstance();
        d.setTime(date);
        return d.get(1) == today.get(1) && d.get(2) == today.get(2) && d.get(5) == today.get(5);
    }

    public static boolean includesToday(Set<Date> dates) {
        Calendar today = Calendar.getInstance();
        Calendar d = Calendar.getInstance();
        for (Date date : dates) {
            d.setTime(date);
            if (d.get(1) != today.get(1) || d.get(2) != today.get(2) || d.get(5) != today.get(5)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasDateInFuture(@Nullable Set<Date> dates) {
        if (dates == null) {
            return false;
        }
        long now = new Date().getTime();
        for (Date d : dates) {
            if (d.getTime() <= now) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static Date min(@Nullable Date a, @Nullable Date b) {
        if (a == null || b == null) {
            return null;
        }
        if (a.getTime() < b.getTime()) {
            return a;
        }
        return b;
    }

    @Nullable
    public static Date max(@Nullable Date a, @Nullable Date b) {
        if (a == null || b == null) {
            return null;
        }
        if (a.getTime() > b.getTime()) {
            return a;
        }
        return b;
    }

    public static LocalDate getDateWithDayOfWeek(LocalDate date, DayOfWeek dayOfWeek) {
        return date.with(WeekFields.SUNDAY_START.dayOfWeek(), dayOfWeek.get(WeekFields.SUNDAY_START.dayOfWeek()));
    }
}

