/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.enums.Enum;
import org.apache.commons.lang.time.DateFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class StringDataUtils {
    private static final Logger logger = LoggerFactory.getLogger(StringDataUtils.class);

    private StringDataUtils() {
    }

    public static String intToString(int value) {
        return String.valueOf(value);
    }

    public static int stringToInt(@Nullable String value, int defaultValue) {
        if (StringUtils.isEmpty((String)(value = StringUtils.trimToEmpty((String)value)))) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static String longToString(long value) {
        return String.valueOf(value);
    }

    public static long stringToLong(@Nullable String value, long defaultValue) {
        if (StringUtils.isEmpty((String)(value = StringUtils.trimToEmpty((String)value)))) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    public static String listOfLongsToString(@Nullable List<Long> values) {
        if (values == null || values.isEmpty()) {
            return "";
        }
        return StringUtils.join(values.iterator(), (char)',');
    }

    public static List<Long> stringToListOfLongs(@Nullable String value) {
        ArrayList<Long> list = new ArrayList<Long>();
        if (value == null || StringUtils.isBlank((String)value)) {
            return list;
        }
        for (String l : value.split("\\s*,\\s*")) {
            if (StringUtils.isBlank((String)l)) continue;
            try {
                list.add(Long.valueOf(StringUtils.trimToEmpty((String)l)));
            }
            catch (NumberFormatException e) {
                logger.error("Encountered bad value in a list of longs: {}", (Object)l);
            }
        }
        return list;
    }

    public static List<String> stringToListOfStrings(@Nullable String value) {
        ArrayList<String> list = new ArrayList<String>();
        if (value == null || StringUtils.isBlank((String)value)) {
            return list;
        }
        for (String l : value.split("\t")) {
            if (StringUtils.isBlank((String)l)) continue;
            list.add(l);
        }
        return list;
    }

    public static String doubleToString(double value) {
        return String.valueOf(value);
    }

    public static double stringToDouble(@Nullable String value, double defaultValue) {
        if (StringUtils.isEmpty((String)(value = StringUtils.trimToEmpty((String)value)))) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(value);
        }
        catch (NumberFormatException nfe) {
            return defaultValue;
        }
    }

    @Nullable
    public static Date stringToDate(String value, @Nullable Date defaultValue) {
        if (StringUtils.isEmpty((String)(value = StringUtils.trimToEmpty((String)value)))) {
            return defaultValue;
        }
        try {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'H:m:s", Locale.US);
            return format.parse(value);
        }
        catch (ParseException pe) {
            logger.error("Error parsing date system property: {}", (Object)value, (Object)pe);
            return defaultValue;
        }
    }

    public static String dateToString(@Nullable Date value) {
        if (value == null) {
            return "";
        }
        return DateFormatUtils.ISO_DATETIME_FORMAT.format(value);
    }

    public static boolean stringToBoolean(@Nullable String value, boolean defaultValue) {
        if (StringUtils.isEmpty((String)(value = StringUtils.trim((String)value)))) {
            return defaultValue;
        }
        char c = value.toUpperCase().charAt(0);
        return c == 'Y' || c == 'T' || c == '1' || "on".equalsIgnoreCase(value);
    }

    public static String booleanToString(boolean value) {
        return value ? "Y" : "N";
    }

    public static String enumToString(@Nullable Enum value) {
        if (value == null) {
            return "";
        }
        return value.getName();
    }

    public static <T extends Enum> T stringToEnum(@Nullable String value, T defaultValue) {
        if (defaultValue == null) {
            throw new IllegalArgumentException("defaultValue cannot be null. To use null default use stringToEnum that takes a class argument.");
        }
        return (T)StringDataUtils.stringToEnum(value, defaultValue.getClass(), defaultValue);
    }

    public static <T extends Enum> T stringToEnum(@Nullable String value, Class<T> enumClass, @Nullable T defaultValue) {
        Object r;
        if (!Enum.class.isAssignableFrom(enumClass)) {
            throw new IllegalArgumentException("type should represent an apache.commons.lang.Enum super class");
        }
        if (StringUtils.isEmpty((String)(value = StringUtils.trimToEmpty((String)value)))) {
            return defaultValue;
        }
        try {
            r = (Enum)enumClass.getDeclaredMethod("getEnum", String.class).invoke(null, value);
        }
        catch (Exception e) {
            logger.debug("Could not create a new Enum object from give type with value: {}", (Object)value);
            return defaultValue;
        }
        if (r == null) {
            r = defaultValue;
        }
        return (T)r;
    }

    @Nullable
    public static String sanitiseString(@Nullable String s) {
        if (s == null) {
            return null;
        }
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char ch = s.charAt(i);
            if ((ch >= ' ' || ch == '\n' || ch == '\r' || ch == '\t') && (ch < '\ud800' || ch >= '\ue000')) continue;
            return StringDataUtils.sanitiseStringInternal(s);
        }
        return s;
    }

    private static String sanitiseStringInternal(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        int l = s.length();
        for (int i = 0; i < l; ++i) {
            char ch = s.charAt(i);
            if (ch < ' ' && ch != '\n' && ch != '\r' && ch != '\t' || ch >= '\ud800' && ch < '\ue000') continue;
            sb.append(ch);
        }
        return sb.toString();
    }
}

