/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util;

import com.google.common.base.Preconditions;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang.ArrayUtils;

public final class UnsignedByteUtils {
    public static final int MIN_VALUE = 0;
    public static final int MAX_VALUE = 255;

    private UnsignedByteUtils() {
    }

    public static byte xor(byte[] unsignedBytes, int startIndex, int length) {
        byte xor = 0;
        for (int i = startIndex; i < length; ++i) {
            xor = (byte)(xor ^ UnsignedByteUtils.toInt(unsignedBytes[i]));
        }
        return xor;
    }

    public static int sum(byte[] unsignedBytes, int startIndex, int length) {
        int sum = 0;
        for (int i = startIndex; i < length; ++i) {
            sum += UnsignedByteUtils.toInt(unsignedBytes[i]);
        }
        return sum;
    }

    public static int toInt(byte unsignedByte) {
        return unsignedByte & 0xFF;
    }

    public static int toInt(byte[] unsignedBytes) {
        int value = 0;
        for (int i = 0; i < unsignedBytes.length; ++i) {
            int shift = (unsignedBytes.length - 1 - i) * 8;
            value += UnsignedByteUtils.toInt(unsignedBytes[i]) << shift;
        }
        return value;
    }

    public static int toInt(byte[] unsignedBytes, int startIndex, int length) {
        byte[] targetBytes = ArrayUtils.subarray((byte[])unsignedBytes, (int)startIndex, (int)(startIndex + length));
        return UnsignedByteUtils.toInt(targetBytes);
    }

    public static String toHexString(byte[] unsignedBytes) {
        if (unsignedBytes == null) {
            return "";
        }
        return String.valueOf(Hex.encodeHex((byte[])unsignedBytes));
    }

    public static String toHexString(byte[] unsignedBytes, int startIndex, int length) {
        if (unsignedBytes == null) {
            return "";
        }
        byte[] targetBytes = ArrayUtils.subarray((byte[])unsignedBytes, (int)startIndex, (int)(startIndex + length));
        return UnsignedByteUtils.toHexString(targetBytes);
    }

    public static byte valueOf(String s) {
        int i = Integer.parseInt(s);
        if (i < 0 || i > 255) {
            throw new NumberFormatException("Value out of range: " + s);
        }
        return (byte)i;
    }

    public static boolean isBitOn(byte b, int bitIndex) {
        byte bitMask;
        int bInt = UnsignedByteUtils.toInt(b);
        byte result = (byte)((bInt & (bitMask = (byte)(1 << bitIndex))) >> bitIndex);
        return result > 0;
    }

    public static byte[] intToByteArray(int value, int length) {
        Preconditions.checkArgument(((double)value < Math.pow(length * 2, 8.0) ? 1 : 0) != 0);
        byte[] a = new byte[length];
        for (int i = 0; i < a.length; ++i) {
            int shift = (length - 1 - i) * 8;
            a[i] = (byte)(value >>> shift);
        }
        return a;
    }
}

