/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.concurrent;

import biz.papercut.pcng.util.concurrent.RateLimiter;
import com.google.common.base.Preconditions;
import com.google.common.base.Ticker;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyedRateLimiter {
    private static final Logger logger = LoggerFactory.getLogger(KeyedRateLimiter.class);
    private final LoadingCache<String, RateLimiter> _limits;

    public KeyedRateLimiter(int maxRequests, int duration, TimeUnit durationUnit) {
        this(maxRequests, duration, durationUnit, null);
    }

    public KeyedRateLimiter(final int maxRequests, final int duration, final TimeUnit durationUnit, final @Nullable Ticker ticker) {
        Preconditions.checkArgument((durationUnit.toSeconds(duration) >= 1L ? 1 : 0) != 0, (Object)"Duration must be greater than 1 second");
        Preconditions.checkArgument((maxRequests > 0 ? 1 : 0) != 0, (Object)"maxRequests must be > 0");
        this._limits = CacheBuilder.newBuilder().expireAfterAccess((long)duration, durationUnit).ticker(ticker != null ? ticker : Ticker.systemTicker()).build((CacheLoader)new CacheLoader<String, RateLimiter>(this){

            public RateLimiter load(String key) {
                return new RateLimiter(maxRequests, duration, durationUnit, ticker);
            }
        });
    }

    public boolean tryAcquire(String key) {
        try {
            return ((RateLimiter)this._limits.get((Object)key)).tryAcquire();
        }
        catch (Exception e) {
            logger.error("Error loading rate limiter entry for: {}. Error: {}", new Object[]{key, e.getMessage(), e});
            return true;
        }
    }

    public boolean isAtLimit(String key) {
        try {
            return ((RateLimiter)this._limits.get((Object)key)).isAtLimit();
        }
        catch (Exception e) {
            logger.error("Error loading rate limiter entry for: {}. Error: {}", new Object[]{key, e.getMessage(), e});
            return true;
        }
    }

    public long remainingCapacity(String key) {
        return ((RateLimiter)this._limits.getUnchecked((Object)key)).remainingCapacity();
    }
}

