/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing;

import biz.papercut.pcng.util.ApplicationInfo;
import biz.papercut.pcng.util.swing.SwingUtils;
import java.awt.Component;
import java.awt.Font;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.annotation.Nullable;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DialogUtils {
    private static final Logger logger = LoggerFactory.getLogger(DialogUtils.class);

    private DialogUtils() {
    }

    public static void showInformationMessageDialog(@Nullable Component parentComponent, String title, String message) {
        logger.debug("Show info msg: {}", (Object)message);
        if (StringUtils.isBlank((String)message)) {
            return;
        }
        JOptionPane pane = new JOptionPane(message, 1);
        JDialog frame = pane.createDialog(parentComponent, DialogUtils.prefixAppName(title));
        frame.setAlwaysOnTop(true);
        DialogUtils.centreFrame(frame);
        frame.setVisible(true);
        logger.debug("completed show message");
    }

    public static void showWarningMessageDialog(@Nullable Component parentComponent, String title, String message) {
        logger.debug("Show warn msg: {}", (Object)message);
        JOptionPane pane = new JOptionPane(message, 2);
        JDialog frame = pane.createDialog(parentComponent, DialogUtils.prefixAppName(title));
        frame.setAlwaysOnTop(true);
        DialogUtils.centreFrame(frame);
        frame.setVisible(true);
        logger.debug("completed show message");
    }

    public static void showErrorMessageDialog(@Nullable Component parentComponent, String title, String message) {
        logger.debug("Show error msg: {}", (Object)message);
        JOptionPane pane = new JOptionPane(message, 0);
        JDialog frame = pane.createDialog(parentComponent, DialogUtils.prefixAppName(title));
        DialogUtils.centreFrame(frame);
        frame.setAlwaysOnTop(true);
        frame.setVisible(true);
        logger.debug("completed show message");
    }

    private static String prefixAppName(String title) {
        try {
            String appName = ApplicationInfo.getInstance().getApplicationName();
            if (StringUtils.isBlank((String)title)) {
                return appName;
            }
            return appName + " - " + title;
        }
        catch (Exception exception) {
            return title;
        }
    }

    public static int showYesNoDialog(Component parent, String title, String message) {
        JOptionPane pane = new JOptionPane(message, 2, 0);
        JDialog frame = pane.createDialog(parent, title);
        DialogUtils.centreFrame(frame);
        frame.setVisible(true);
        return DialogUtils.getOptionPaneReturnValue(pane);
    }

    private static int getOptionPaneReturnValue(JOptionPane pane) {
        Object selectedValue = pane.getValue();
        if (selectedValue == null) {
            return -1;
        }
        Object[] options = pane.getOptions();
        if (options == null) {
            if (selectedValue instanceof Integer) {
                return (Integer)selectedValue;
            }
            return -1;
        }
        int maxCounter = options.length;
        for (int counter = 0; counter < maxCounter; ++counter) {
            if (!options[counter].equals(selectedValue)) continue;
            return counter;
        }
        return -1;
    }

    public static void centreFrame(Window frame) {
        frame.setLocationRelativeTo(null);
    }

    public static void setTextHandlingFontDisplayProblems(JLabel label, String text) {
        Font currentFont = label.getFont();
        if (!currentFont.getName().equalsIgnoreCase("SanSerif") && (DialogUtils.containsNonLatinChars(text) || SwingUtils.isLocaleThatHasFontDisplayProblems())) {
            logger.debug("Problem Font detected. Setting to SanSerif");
            label.setFont(new Font("SanSerif", currentFont.getStyle(), currentFont.getSize()));
        }
        label.setText(text);
    }

    private static boolean containsNonLatinChars(String s) {
        for (int i = 0; i < s.length(); ++i) {
            int codePoint = s.codePointAt(i);
            if (codePoint < 0) {
                return true;
            }
            if (codePoint <= 255 || codePoint == 8364) continue;
            return true;
        }
        return false;
    }

    public static void forceRepaintAfterOpened(final Window window) {
        window.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                String windowId = window.getClass().getSimpleName();
                long delay = 500L;
                logger.debug("{} opened, force repaint in 500ms", (Object)windowId);
                Thread t = new Thread(() -> {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    logger.debug("Force repaint");
                    window.setSize(window.getWidth() + 1, window.getHeight());
                }, "force-repaint-" + windowId);
                t.setDaemon(true);
                t.start();
            }
        });
    }
}

