/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.util.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import javax.swing.JPanel;

public class GradientPanel
extends JPanel {
    private final boolean _vertical;
    private final Color _middleColor;
    private final Color _edgeColor;

    public GradientPanel(Color middleColor, Color edgeColor, boolean vertical) {
        this._middleColor = middleColor;
        this._edgeColor = edgeColor;
        this._vertical = vertical;
        this.setPreferredSize(new Dimension(2, 2));
    }

    @Override
    public void paint(Graphics g1) {
        Point2D.Double pointEdgeB;
        Point2D.Double pointEdgeA;
        Graphics2D g = (Graphics2D)g1;
        if (this._vertical) {
            pointEdgeA = new Point2D.Double((double)this.getWidth() / 2.0, 0.0);
            pointEdgeB = new Point2D.Double((double)this.getWidth() / 2.0, this.getHeight());
        } else {
            pointEdgeA = new Point2D.Double(0.0, (double)this.getHeight() / 2.0);
            pointEdgeB = new Point2D.Double(this.getWidth(), (double)this.getHeight() / 2.0);
        }
        Point2D.Double pointMiddle = new Point2D.Double((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
        GradientPaint gradientA = new GradientPaint(pointEdgeA, this._edgeColor, pointMiddle, this._middleColor);
        GradientPaint gradientB = new GradientPaint(pointMiddle, this._middleColor, pointEdgeB, this._edgeColor);
        if (this._vertical) {
            g.setPaint(gradientA);
            g.fillRect(0, 0, this.getWidth(), this.getHeight() / 2);
            g.setPaint(gradientB);
            g.fillRect(0, this.getHeight() / 2, this.getWidth(), this.getHeight());
        } else {
            g.setPaint(gradientA);
            g.fillRect(0, 0, this.getWidth() / 2, this.getHeight());
            g.setPaint(gradientB);
            g.fillRect(this.getWidth() / 2, 0, this.getWidth(), this.getHeight());
        }
    }
}

