/*
 * Decompiled with CFR 0.152.
 */
package net.java.plaf.windows.common;

import com.sun.java.swing.plaf.windows.WindowsLookAndFeel;
import com.sun.java.swing.plaf.windows.WindowsMenuUI;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import net.java.plaf.windows.common.CommonMenuItemUI;
import net.java.plaf.windows.common.MenuItemPainter;

public class WindowsMenuUI
extends com.sun.java.swing.plaf.windows.WindowsMenuUI
implements CommonMenuItemUI {
    private String _acceleratorDelimiter;
    private MenuItemPainter _painter;
    private FocusHandler focusHandler;
    private boolean m_mouseOver = false;

    public static ComponentUI createUI(JComponent comp) {
        return new WindowsMenuUI();
    }

    protected void installDefaults() {
        super.installDefaults();
        this._acceleratorDelimiter = UIManager.getString("MenuItem.acceleratorDelimiter");
        if (this._acceleratorDelimiter == null) {
            this._acceleratorDelimiter = "+";
        }
        this._painter = new MenuItemPainter(this);
    }

    protected Dimension getPreferredMenuItemSize(JComponent c, Icon checkIcon, Icon arrowIcon, int defaultTextIconGap) {
        if (((JMenu)c).isTopLevelMenu()) {
            return super.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
        }
        return this._painter.getPreferredMenuItemSize(c, checkIcon, arrowIcon, defaultTextIconGap);
    }

    protected void paintMenuItem(Graphics g, JComponent c, Icon checkIcon, Icon arrowIcon, Color background, Color foreground, int defaultTextIconGap) {
        if (((JMenu)c).isTopLevelMenu()) {
            super.paintMenuItem(g, c, checkIcon, arrowIcon, background, foreground, defaultTextIconGap);
        } else {
            this._painter.paintMenuItem(g, c, checkIcon, arrowIcon, background, foreground, defaultTextIconGap);
        }
    }

    protected void installListeners() {
        super.installListeners();
        this.focusHandler = new FocusHandler();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addPropertyChangeListener("activeWindow", this.focusHandler);
    }

    protected void uninstallListeners() {
        super.uninstallListeners();
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removePropertyChangeListener(this.focusHandler);
    }

    public void paint(Graphics g, JComponent c) {
        if (WindowsLookAndFeel.isClassicWindows()) {
            super.paint(g, c);
        } else {
            Window window = SwingUtilities.windowForComponent(c);
            Color oldColor = g.getColor();
            if (((JMenu)c).isTopLevelMenu() && !window.isActive()) {
                g.setColor(this.disabledForeground);
            }
            super.paint(g, c);
            g.setColor(oldColor);
        }
    }

    protected MouseInputListener createMouseInputListener(JComponent jc) {
        return new XPMouseInputHandler();
    }

    public String getAcceleratorDelimiter() {
        return this._acceleratorDelimiter;
    }

    public Font getAcceleratorFont() {
        return this.acceleratorFont;
    }

    public JMenuItem getMenuItem() {
        return this.menuItem;
    }

    public boolean isMouseOver() {
        return this.m_mouseOver;
    }

    public Color getSelectionForeground() {
        return this.selectionForeground;
    }

    public Color getDisabledForeground() {
        return this.disabledForeground;
    }

    public Color getAcceleratorForeground() {
        return this.acceleratorForeground;
    }

    public Color getAcceleratorSelectionForeground() {
        return this.acceleratorSelectionForeground;
    }

    protected class XPMouseInputHandler
    extends WindowsMenuUI.WindowsMouseInputHandler {
        protected XPMouseInputHandler() {
            super((com.sun.java.swing.plaf.windows.WindowsMenuUI)WindowsMenuUI.this);
        }

        public void mouseEntered(MouseEvent me) {
            super.mouseEntered(me);
            if (!((JMenu)me.getSource()).isTopLevelMenu() && !WindowsMenuUI.this.menuItem.isEnabled()) {
                MenuSelectionManager.defaultManager().setSelectedPath(WindowsMenuUI.this.getPath());
                WindowsMenuUI.this.m_mouseOver = true;
                WindowsMenuUI.this.menuItem.repaint();
            }
        }

        public void mouseExited(MouseEvent me) {
            super.mouseExited(me);
            if (!((JMenu)me.getSource()).isTopLevelMenu() && !WindowsMenuUI.this.menuItem.isEnabled()) {
                WindowsMenuUI.this.m_mouseOver = false;
                WindowsMenuUI.this.menuItem.repaint();
            }
        }
    }

    private class FocusHandler
    implements PropertyChangeListener {
        private FocusHandler() {
        }

        public void propertyChange(PropertyChangeEvent event) {
            MenuSelectionManager manager = MenuSelectionManager.defaultManager();
            if (manager != null && manager.getSelectedPath().length > 0) {
                manager.clearSelectedPath();
                return;
            }
            if (WindowsMenuUI.this.menuItem != null) {
                WindowsMenuUI.this.menuItem.repaint();
                WindowsMenuUI.this.menuItem.validate();
            }
        }
    }
}

