#!/bin/bash

no_root () {
	echo
	echo " Eseguire lo script come root"
	echo " o con privilegi di root (sudo)"
	echo
	echo " This script must be executed as root"
	echo " or with root privileges (sudo)"
	echo
	exit -1
}

[ "$USER" != "root" ] && no_root

rm -rf /usr/local/pc-client

cp -rf pc-client/ /usr/local/ 
[ -d /usr/share/ppd/cupsfilters ] && cp print.ppd /usr/share/ppd/cupsfilters
[ -d /usr/lib/cups/filter ] && cp filters/* /usr/lib/cups/filter
[ -d /etc/xdg/autostart ] && cp pc-client.desktop /etc/xdg/autostart/
[ -d /usr/share/applications ] && cp pc-client.desktop /usr/share/applications
[ -d /usr/share/menu ] && cp pc-client.menu /usr/share/menu/pc-client
[ -x /usr/bin/update-menus ] && /usr/bin/update-menus
[ -x /usr/bin/update-desktop-database ] && [ -d /usr/share/applications ] && /usr/bin/update-desktop-database
/usr/sbin/lpadmin -p papercut -v ipp://print.dei.unipd.it/printers/print -E -P ./print.ppd -D "PaperCut Kyocera DEI" -L "DEI"

systemctl restart cups

cat <<END_MESSAGE

:::::::::::::::::ITALIANO::::::::::::::::::::::
La stampante "papercut" è stata installata sul computer e configurata
con le seguenti opzioni abilitate di default:

    - bianco e nero
    - fronte retro (lato lungo)

Per renderla la stampante predefinita potete digitare da riga di
comando (come utente senza privilegi):
lpadmin -d papercut

Si ricorda che per stampare è necessario sia attivo il client PaperCut:
- dopo l'installazione, per avviare il programma cercare PaperCut-client
dal menu delle applicazioni e aprirlo;
- in seguito il programma dovrebbe avviarsi in automatico a ogni avvio
del sistema.

:::::::::::::::::::::::::::::::::::::::::::::::

:::::::::::::::::ENGLISH:::::::::::::::::::::::
The "papercut" printer has been installed and configured with the
following defaults:

    - black and white printing
    - duplex (long edge)

To set it this as your default printer, input the following command
through command line (as your normal user)

lpadmin -d papercut

Please remember that the PaperCut client must be running to allow
printing:
- after the installation, look for PaperCut-client in the app menu and
clic to open it;
- afterwards, the program should automatically start at every system
startup.

:::::::::::::::::::::::::::::::::::::::::::::::

END_MESSAGE
