/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.Messages;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.common.ClientGlobalConfigFromServer;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthPanel
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(AuthPanel.class);
    private JTextField _username;
    private JPasswordField _password;
    private JComboBox<TTLValue> _ttl;
    private final UserClientConfig _clientConfig;
    private boolean _authByIdNumber;
    private boolean _requirePin;
    private final ClientGlobalConfigFromServer _globalServerConfig;

    public AuthPanel(UserClientConfig clientConfig, ClientGlobalConfigFromServer globalServerConfig) {
        this._clientConfig = clientConfig;
        this._globalServerConfig = globalServerConfig;
        this.initComponents();
        this.layoutComponents();
        this._username.requestFocusInWindow();
    }

    private void initComponents() {
        this._username = new JTextField();
        this._password = new JPasswordField();
        String valuesStr = StringUtils.trimToEmpty((String)this._clientConfig.getAuthTTLValues());
        if (valuesStr.isEmpty()) {
            valuesStr = StringUtils.trimToEmpty((String)this._clientConfig.getServerGlobalConfig().getAuthTTLValues());
        }
        if (valuesStr.isEmpty()) {
            logger.debug("using default ttl values");
            valuesStr = "1,5,15,30,60,-1";
        }
        logger.debug("Auth TTL values: {}", (Object)valuesStr);
        String[] valuesMinutes = valuesStr.split("\\s*,\\s*");
        ArrayList<TTLValue> values = new ArrayList<TTLValue>();
        for (String valuesMinute : valuesMinutes) {
            try {
                int val = Integer.parseInt(valuesMinute);
                if (val < 0) {
                    if (val == -1) {
                        values.add(new TTLValue(-1, AuthPanel.format("always", new String[0])));
                        continue;
                    }
                    if (val == -2) {
                        values.add(new TTLValue(-2, AuthPanel.format("indefinitely", new String[0])));
                        continue;
                    }
                    logger.debug("Unknown negative TTL value");
                    continue;
                }
                if (val == 0) {
                    values.add(new TTLValue(0, AuthPanel.format("for-this-job-only", new String[0])));
                    continue;
                }
                values.add(new TTLValue(val * 60, AuthPanel.format("minutes", Integer.toString(val))));
            }
            catch (Exception e) {
                logger.error("Unable to parse auth TTL value: {}", (Object)valuesMinute);
            }
        }
        this._ttl = new JComboBox<TTLValue>(values.toArray(new TTLValue[0]));
        int authDefault = this._clientConfig.getAuthTTLDefault() != null ? this._clientConfig.getAuthTTLDefault().intValue() : this._clientConfig.getServerGlobalConfig().getAuthTTLDefault();
        logger.debug("Auth TTL default: {}", (Object)authDefault);
        if (authDefault < 0) {
            for (int i = 0; i < this._ttl.getItemCount(); ++i) {
                TTLValue v = this._ttl.getItemAt(i);
                if (authDefault != v.getSeconds()) continue;
                this._ttl.setSelectedIndex(i);
                break;
            }
        } else {
            int defaultSeconds = authDefault * 60;
            for (int i = 0; i < this._ttl.getItemCount(); ++i) {
                TTLValue v = this._ttl.getItemAt(i);
                if (v.getSeconds() != defaultSeconds) continue;
                this._ttl.setSelectedIndex(i);
                break;
            }
        }
    }

    private void layoutComponents() {
        this._authByIdNumber = this._globalServerConfig.isAuthByIdNumber();
        this._requirePin = this._globalServerConfig.isRequirePin();
        if (this._clientConfig.isDisableAuthByIdNumber()) {
            this._authByIdNumber = false;
        }
        boolean requirePass = !this._authByIdNumber || this._requirePin;
        String usernameLabel = this._authByIdNumber ? "id-number" : "username";
        String passwordLabel = this._authByIdNumber ? "pin" : "password";
        FormLayout layout = new FormLayout("15dlu, right:max(pref;40dlu), 3dlu, max(pref;120dlu):grow, 20dlu", "0dlu:grow, pref, 3dlu, pref, 3dlu, pref, 0dlu:grow");
        if (requirePass) {
            layout.setRowGroups((int[][])new int[][]{{2, 4, 6}});
        } else {
            layout.setRowGroups((int[][])new int[][]{{2, 4}});
        }
        DefaultFormBuilder builder = new DefaultFormBuilder(layout, (JPanel)this);
        builder.setDefaultDialogBorder();
        builder.setRow(2);
        builder.setColumn(2);
        builder.append(AuthPanel.format(usernameLabel, new String[0]), (Component)this._username);
        builder.nextLine(2);
        if (requirePass) {
            builder.setColumn(2);
            builder.append(AuthPanel.format(passwordLabel, new String[0]), (Component)this._password);
            builder.nextLine(2);
        }
        builder.setColumn(2);
        builder.append(AuthPanel.format("remember-for", new String[0]), this._ttl);
    }

    public String getUsername() {
        return this._username.getText();
    }

    public String getPassword() {
        return new String(this._password.getPassword());
    }

    public boolean isAuthByIdNumber() {
        return this._authByIdNumber;
    }

    public boolean isRequirePin() {
        return this._requirePin;
    }

    public int getTimeToLiveSeconds() {
        return ((TTLValue)this._ttl.getSelectedItem()).getSeconds();
    }

    public void setDefaultTTLSecs(int secs) {
        for (int i = 0; i < this._ttl.getItemCount(); ++i) {
            TTLValue v = this._ttl.getItemAt(i);
            if (v.getSeconds() < secs) continue;
            this._ttl.setSelectedIndex(i);
        }
    }

    private static String format(String key, String ... args) {
        String fullKey = "AuthPanel." + key;
        return Messages.getString(AuthPanel.class, fullKey, args);
    }

    private static class TTLValue {
        private int _seconds;
        private String _description;

        public TTLValue(int seconds, String description) {
            this._seconds = seconds;
            this._description = description;
        }

        public String getDescription() {
            return this._description;
        }

        public void setDescription(String description) {
            this._description = description;
        }

        public int getSeconds() {
            return this._seconds;
        }

        public void setSeconds(int seconds) {
            this._seconds = seconds;
        }

        public String toString() {
            return this._description;
        }
    }
}

