/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.client.uit.UserClientFrame;
import biz.papercut.pcng.common.ClientAction;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogRequestWithJobInfo;
import com.google.common.base.Stopwatch;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientController
extends Thread {
    private static final Logger logger = LoggerFactory.getLogger(ClientController.class);
    private static final int BALANCE_CHECK_WAIT_MS = 1000;
    private final AtomicBoolean shutdownRequested = new AtomicBoolean(false);
    private final ServerConnection _connection;
    private final UserClientConfig _config;
    private final UserClientFrame _frame;
    private final Set<MessageListener> _msgListeners = new HashSet<MessageListener>(1);
    private final Set<PrintJobListener> _printJobListeners = new HashSet<PrintJobListener>(1);
    private final Set<BalanceUpdateListener> _balanceListeners = new HashSet<BalanceUpdateListener>(1);
    private final Set<AuthenticationEventListener> _authListeners = new HashSet<AuthenticationEventListener>(1);
    private final Set<DialogRequestListener> _dialogRequestListeners = new HashSet<DialogRequestListener>(1);

    ClientController(ServerConnection connection, UserClientConfig clientConfig, UserClientFrame frame) {
        this._connection = connection;
        this._config = clientConfig;
        this._frame = frame;
        this.setName("client-controller-" + this.getId());
        this.setDaemon(true);
    }

    void addMessageListener(MessageListener listener) {
        this._msgListeners.add(listener);
    }

    void addPrintJobListener(PrintJobListener listener) {
        this._printJobListeners.add(listener);
    }

    void addDialogRequestListener(DialogRequestListener listener) {
        this._dialogRequestListeners.add(listener);
    }

    void addBalanceListener(BalanceUpdateListener listener) {
        this._balanceListeners.add(listener);
    }

    void addAuthenticationRequestListener(AuthenticationEventListener listener) {
        this._authListeners.add(listener);
    }

    @Override
    public void run() {
        Random rand = new Random();
        boolean offline = false;
        Stopwatch stopwatch = Stopwatch.createStarted();
        while (!this.isShutdownRequested()) {
            try {
                List actions = this._frame.withClientActionLock(() -> this._connection.getPendingActions(this._config.getTimeoutSecs()));
                logger.debug("Client controller: getPendingActions={}", (Object)actions);
                if (this.isShutdownRequested()) break;
                if (offline) {
                    this._frame.setOfflineIcon(false);
                    offline = false;
                }
                this._frame.withClientActionLock(() -> {
                    this.handleClientActions(actions);
                    return null;
                });
                if (!actions.isEmpty()) continue;
                Thread.sleep(rand.nextInt(1000));
            }
            catch (Throwable t) {
                this._frame.setOfflineIcon(true);
                offline = true;
                long delayMillis = 15000 + rand.nextInt(Math.max(30, this._config.getTimeoutSecs()) * 1000);
                logger.error("Error fetching client actions. Delay reconnections for {} millis", (Object)delayMillis, (Object)t);
                Uninterruptibles.sleepUninterruptibly((long)delayMillis, (TimeUnit)TimeUnit.MILLISECONDS);
            }
        }
        logger.info("Client controller shutdown after: {} seconds", (Object)stopwatch.elapsed(TimeUnit.SECONDS));
    }

    private void handleClientActions(List<ClientAction> actions) throws InterruptedException {
        block8: for (ClientAction action : actions) {
            switch (action) {
                case UserMessages: {
                    this.sendMessagesToListeners(this._connection.getPendingMessages());
                    continue block8;
                }
                case PrintJobs: {
                    this.sendPrintJobsToListeners(this._connection.getPendingPrintJobs());
                    continue block8;
                }
                case BalanceUpdate: {
                    Thread.sleep(1000L);
                    this.sendBalanceToListeners(this._connection.getUserBalance(this._config.getDisplayUserName()));
                    continue block8;
                }
                case AuthenticationRequested: {
                    this.sendAuthenticationRequestToListeners();
                    continue block8;
                }
                case AuthenticationExpired: {
                    this.sendAuthenticationExpiredEventToListeners();
                    continue block8;
                }
                case DialogRequest: {
                    this.sendDialogRequestsToListeners(this._connection.getPendingClientDialogs());
                    continue block8;
                }
            }
            logger.debug("Unknown action: {}.", (Object)action);
        }
    }

    private void sendMessagesToListeners(List<String> msgs) {
        if (msgs == null || msgs.isEmpty()) {
            return;
        }
        for (MessageListener listener : this._msgListeners) {
            try {
                listener.newMessages(msgs, this._config);
            }
            catch (Throwable t) {
                logger.error("Error sending new messages to listener: {}. {}", new Object[]{listener, t.getMessage(), t});
            }
        }
    }

    private void sendPrintJobsToListeners(List<ClientPrintJob> printJobs) {
        if (printJobs == null || printJobs.isEmpty()) {
            return;
        }
        for (PrintJobListener listener : this._printJobListeners) {
            try {
                listener.newPrintJobs(printJobs);
            }
            catch (Throwable t) {
                logger.error("Error sending new print jobs to listener: {}. {}", new Object[]{listener, t.getMessage(), t});
            }
        }
    }

    private void sendDialogRequestsToListeners(List<ClientDialogRequestWithJobInfo> list) {
        if (list == null || list.isEmpty()) {
            return;
        }
        for (DialogRequestListener listener : this._dialogRequestListeners) {
            try {
                listener.newDialogRequests(list);
            }
            catch (Throwable t) {
                logger.error("Error sending new dialogs to listener: {}. {}", new Object[]{listener, t.getMessage(), t});
            }
        }
    }

    private void sendAuthenticationRequestToListeners() {
        for (AuthenticationEventListener listener : this._authListeners) {
            try {
                listener.newAuthenticationRequest();
            }
            catch (Throwable t) {
                logger.error("Error sending new auth request to listener: {}. {}", new Object[]{listener, t.getMessage(), t});
            }
        }
    }

    private void sendAuthenticationExpiredEventToListeners() {
        for (AuthenticationEventListener listener : this._authListeners) {
            try {
                listener.authenticationExpired();
            }
            catch (Throwable t) {
                logger.error("Error sending new auth expired listeners: {}. {}", new Object[]{listener, t.getMessage(), t});
            }
        }
    }

    private void sendBalanceToListeners(String balance) {
        for (BalanceUpdateListener listener : this._balanceListeners) {
            try {
                listener.newBalance(balance);
            }
            catch (Throwable t) {
                logger.error("Error sending new balance to listener: {}. {}", new Object[]{listener, t.getMessage(), t});
            }
        }
    }

    void requestShutdown() {
        this.shutdownRequested.set(true);
    }

    private boolean isShutdownRequested() {
        return this.shutdownRequested.get() || this.isInterrupted();
    }

    public static interface MessageListener {
        public void newMessages(List<String> var1, UserClientConfig var2);
    }

    public static interface PrintJobListener {
        public void newPrintJobs(List<ClientPrintJob> var1);
    }

    public static interface DialogRequestListener {
        public void newDialogRequests(List<ClientDialogRequestWithJobInfo> var1);
    }

    public static interface AuthenticationEventListener {
        public void newAuthenticationRequest();

        public void authenticationExpired();
    }

    public static interface BalanceUpdateListener {
        public void newBalance(String var1);
    }
}

