/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit;

import biz.papercut.pcng.client.uit.CustomMessagePrintDialog;
import biz.papercut.pcng.client.uit.ServerConnection;
import biz.papercut.pcng.client.uit.UserClientConfig;
import biz.papercut.pcng.common.ClientPrintJob;
import biz.papercut.pcng.common.client.dialogrequest.ClientDialogResponse;
import biz.papercut.pcng.common.client.dialogrequest.HTMLFormDialogResponse;
import biz.papercut.pcng.common.client.dialogrequest.MessageDialogRequest;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JFrame;
import javax.swing.ListSelectionModel;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.ElementIterator;
import javax.swing.text.StyleConstants;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CustomHTMLFormPrintDialog
extends CustomMessagePrintDialog {
    private static final Logger logger = LoggerFactory.getLogger(CustomHTMLFormPrintDialog.class);

    public static CustomHTMLFormPrintDialog construct(JFrame owner, MessageDialogRequest request, ClientPrintJob job, ServerConnection conn, UserClientConfig config) {
        CustomHTMLFormPrintDialog d = new CustomHTMLFormPrintDialog(owner, request, job, conn, config);
        d.initializeMessageDialog();
        return d;
    }

    public CustomHTMLFormPrintDialog(JFrame owner, MessageDialogRequest request, ClientPrintJob job, ServerConnection conn, UserClientConfig config) {
        super(owner, request, job, conn, config);
    }

    @Override
    protected boolean handleButtonPress(String button) {
        Map<String, String> formData;
        try {
            formData = this.buildFormData((HTMLDocument)this._message.getDocument());
        }
        catch (Exception e) {
            logger.error("Error extracting form data: {}", (Object)e.getMessage(), (Object)e);
            formData = Collections.emptyMap();
        }
        this._conn.setClientDialogResponse(this._job.getJobId(), this._request.getUniqueID(), (ClientDialogResponse)new HTMLFormDialogResponse(button, formData));
        return true;
    }

    private Map<String, String> buildFormData(HTMLDocument htmlDoc) {
        Element next;
        HashMap<String, String> data = new HashMap<String, String>();
        ElementIterator it = new ElementIterator(htmlDoc.getRootElements()[0]);
        while ((next = it.next()) != null) {
            if (!next.isLeaf()) continue;
            this.loadElementDataIntoMap(next, data);
        }
        return data;
    }

    private void loadElementDataIntoMap(Element elem, Map<String, String> data) {
        AttributeSet attr = elem.getAttributes();
        String name = (String)attr.getAttribute(HTML.Attribute.NAME);
        if (name == null) {
            return;
        }
        String value = null;
        HTML.Tag tag = (HTML.Tag)elem.getAttributes().getAttribute(StyleConstants.NameAttribute);
        if (tag == HTML.Tag.INPUT) {
            value = this.getInputElementData(attr);
        } else if (tag == HTML.Tag.TEXTAREA) {
            value = this.getTextAreaData(attr);
        } else if (tag == HTML.Tag.SELECT) {
            this.loadSelectData(attr, data);
        }
        if (name != null && value != null) {
            data.put(name, value);
        }
    }

    private String getInputElementData(AttributeSet attr) {
        Object model = attr.getAttribute(StyleConstants.ModelAttribute);
        String type = (String)attr.getAttribute(HTML.Attribute.TYPE);
        String value = null;
        switch (type) {
            case "text": 
            case "password": {
                Document doc = (Document)model;
                try {
                    value = doc.getText(0, doc.getLength());
                }
                catch (BadLocationException e) {
                    value = null;
                }
                break;
            }
            case "submit": 
            case "hidden": {
                value = (String)attr.getAttribute(HTML.Attribute.VALUE);
                if (value != null) break;
                value = "";
                break;
            }
            case "radio": 
            case "checkbox": {
                ButtonModel m = (ButtonModel)model;
                if (!m.isSelected() || (value = (String)attr.getAttribute(HTML.Attribute.VALUE)) != null) break;
                value = "on";
            }
        }
        return value;
    }

    private String getTextAreaData(AttributeSet attr) {
        Document doc = (Document)attr.getAttribute(StyleConstants.ModelAttribute);
        try {
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException e) {
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    private void loadSelectData(AttributeSet attr, Map<String, String> data) {
        String name = (String)attr.getAttribute(HTML.Attribute.NAME);
        if (name == null) {
            return;
        }
        Object m = attr.getAttribute(StyleConstants.ModelAttribute);
        if (m instanceof ListSelectionModel) {
            ListSelectionModel lsm = (ListSelectionModel)m;
            if (m instanceof DefaultListModel) {
                DefaultListModel model = (DefaultListModel)m;
                int i = 0;
                while (i < model.getSize()) {
                    if (lsm.isSelectedIndex(i)) {
                        Option option = (Option)model.getElementAt(i);
                        data.put(name, option.getValue());
                    }
                    ++i;
                }
                return;
            }
        }
        if (!(m instanceof ComboBoxModel)) return;
        ComboBoxModel model = (ComboBoxModel)m;
        Option option = (Option)model.getSelectedItem();
        if (option == null) return;
        data.put(name, option.getValue());
    }
}

