/*
 * Decompiled with CFR 0.152.
 */
package biz.papercut.pcng.client.uit.accounts;

import biz.papercut.pcng.client.uit.accounts.AccountIdListModel;
import biz.papercut.pcng.common.ClientAccount;
import biz.papercut.pcng.util.Messages;
import biz.papercut.pcng.util.swing.EnterFilteringInputMap;
import biz.papercut.pcng.util.swing.SwingUtils;
import com.google.common.base.Stopwatch;
import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferredList
extends JPanel {
    private static final Logger logger = LoggerFactory.getLogger(PreferredList.class);
    protected static final int COL_IDX_ACCOUNT = 0;
    protected static final int COL_IDX_CODE = 1;
    private static final int PREF_WIDTH = 100;
    private static long s_lastSelection = -1L;
    private JTable _table;
    private JButton _moveUpButton;
    private JButton _moveDownButton;
    private PreferredListTableModel _tableModel;
    private AccountIdListModel _preferredAccounts;
    private final boolean _showCode;

    public PreferredList(boolean showCode) {
        this._showCode = showCode;
        this.layoutComponents();
    }

    public void loadData(List<ClientAccount> accounts, AccountIdListModel preferredAccounts) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        this._preferredAccounts = preferredAccounts;
        this._tableModel.loadData(accounts, preferredAccounts);
        this.selectLastSelectedAccount();
        logger.debug("Loading {} accounts in PreferredList took {} ms", (Object)accounts.size(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
    }

    public void dispose() {
        this._tableModel.dispose();
    }

    private void layoutComponents() {
        this._tableModel = new PreferredListTableModel();
        this._table = new JTable(this._tableModel);
        EnterFilteringInputMap.applyToComponent((JComponent)this._table);
        if (!this._showCode) {
            TableColumnModel colModel = this._table.getColumnModel();
            colModel.removeColumn(colModel.getColumn(1));
        }
        this._table.setPreferredScrollableViewportSize(new Dimension(100, 50));
        this._table.setShowVerticalLines(false);
        this._table.setShowHorizontalLines(false);
        this._table.setOpaque(false);
        this._table.setSelectionMode(0);
        this._table.getSelectionModel().addListSelectionListener(e -> {
            ClientAccount a = this.getSelectedAccount();
            if (a != null && !a.isDisabled()) {
                s_lastSelection = a.getAccountId();
            }
        });
        DefaultTableCellRenderer accountRenderer = new DefaultTableCellRenderer(){

            @Override
            public void setValue(Object value) {
                super.setValue(value);
                if (value instanceof ClientAccount) {
                    ClientAccount ca = (ClientAccount)value;
                    this.setEnabled(!ca.isDisabled());
                }
            }
        };
        TableColumn accountCol = this._table.getColumn(Messages.getString(this.getClass(), (String)"Common.HEADING_ACCOUNT", (String[])new String[0]));
        accountCol.setCellRenderer(accountRenderer);
        JScrollPane scrollPane = new JScrollPane(this._table);
        scrollPane.getViewport().setBackground(this._table.getBackground());
        scrollPane.setOpaque(false);
        FormLayout layout = new FormLayout("pref:grow, 4dlu, pref", "bottom:pref:grow(0.5),4dlu,top:pref:grow(0.5)");
        PanelBuilder builder = new PanelBuilder(layout, (JPanel)this);
        CellConstraints cc = new CellConstraints();
        builder.setBorder(Borders.createEmptyBorder((String)"4dlu, 4dlu, 4dlu, 4dlu"));
        builder.add((Component)scrollPane, cc.xywh(1, 1, 1, 3, CellConstraints.FILL, CellConstraints.FILL));
        builder.add((Component)this.getMoveUpButton(), cc.xy(3, 1));
        builder.add((Component)this.getMoveDownButton(), cc.xy(3, 3));
    }

    private void selectLastSelectedAccount() {
        ClientAccount ca;
        int i;
        PreferredListTableModel model = (PreferredListTableModel)this._table.getModel();
        int rowCount = model.getRowCount();
        if (rowCount < 1) {
            return;
        }
        if (s_lastSelection > 0L) {
            for (i = 0; i < rowCount; ++i) {
                ca = (ClientAccount)model.getValueAt(i, 0);
                if (ca == null || ca.getAccountId() != s_lastSelection) continue;
                this._table.changeSelection(i, 0, false, false);
                return;
            }
        }
        for (i = 0; i < 100; ++i) {
            ca = (ClientAccount)model.getValueAt(i, 0);
            if (ca == null || ca.isDisabled()) continue;
            this._table.changeSelection(i, 0, false, false);
            return;
        }
        this._table.changeSelection(0, 0, false, false);
    }

    public ClientAccount getSelectedAccount() {
        PreferredListTableModel model = (PreferredListTableModel)this._table.getModel();
        int row = this._table.getSelectedRow();
        if (row >= 0) {
            return (ClientAccount)model.getValueAt(row, 0);
        }
        return null;
    }

    public void addListSelectionListener(ListSelectionListener listener) {
        this._table.getSelectionModel().addListSelectionListener(listener);
    }

    private JButton getMoveUpButton() {
        if (this._moveUpButton == null) {
            this._moveUpButton = new JButton();
            this._moveUpButton.setText(Messages.getString(this.getClass(), (String)"PreferredList.MOVE_UP", (String[])new String[0]));
            this._moveUpButton.addActionListener(e -> {
                int currentidx = this._table.getSelectedRow();
                if (currentidx <= 0) {
                    return;
                }
                ClientAccount c1 = (ClientAccount)this._tableModel.getValueAt(currentidx, 0);
                ClientAccount c2 = (ClientAccount)this._tableModel.getValueAt(currentidx - 1, 0);
                this._preferredAccounts.swap(c1.getAccountId(), c2.getAccountId());
                this._table.changeSelection(currentidx - 1, 0, false, false);
            });
        }
        SwingUtils.setOpaqueIfRequired((JButton)this._moveUpButton);
        return this._moveUpButton;
    }

    private JButton getMoveDownButton() {
        if (this._moveDownButton == null) {
            this._moveDownButton = new JButton();
            this._moveDownButton.setText(Messages.getString(this.getClass(), (String)"PreferredList.MOVE_DOWN", (String[])new String[0]));
            this._moveDownButton.addActionListener(e -> {
                int currentidx = this._table.getSelectedRow();
                if (currentidx >= this._table.getRowCount() - 1 || currentidx < 0) {
                    return;
                }
                ClientAccount c1 = (ClientAccount)this._tableModel.getValueAt(currentidx, 0);
                ClientAccount c2 = (ClientAccount)this._tableModel.getValueAt(currentidx + 1, 0);
                this._preferredAccounts.swap(c1.getAccountId(), c2.getAccountId());
                this._table.changeSelection(currentidx + 1, 0, false, false);
            });
        }
        SwingUtils.setOpaqueIfRequired((JButton)this._moveDownButton);
        return this._moveDownButton;
    }

    public static class PreferredListTableModel
    extends AbstractTableModel {
        private static final Logger logger = LoggerFactory.getLogger(PreferredListTableModel.class);
        private static final long serialVersionUID = -8547989592172491421L;
        private AccountIdListModel _preferredAccountIds;
        private List<ClientAccount> _preferredAccountsList;

        PreferredListTableModel() {
            ClientAccount ca = new ClientAccount(1L);
            ca.setDisabled(true);
            ca.setParentName(Messages.getString(this.getClass(), (String)"Common.LOADING", (String[])new String[0]));
            this._preferredAccountsList = new ArrayList<ClientAccount>(1);
            this._preferredAccountsList.add(ca);
        }

        public void loadData(List<ClientAccount> accounts, AccountIdListModel preferredAccountIds) {
            this._preferredAccountIds = preferredAccountIds;
            this.buildList(accounts);
            this._preferredAccountIds.addChangeListener(e -> {
                this.buildList(accounts);
                this.fireTableDataChanged();
            });
            this.fireTableDataChanged();
        }

        public void dispose() {
            this._preferredAccountsList.clear();
        }

        private void buildList(List<ClientAccount> accounts) {
            this._preferredAccountsList = new ArrayList<ClientAccount>(this._preferredAccountIds.size());
            for (int i = 0; i < this._preferredAccountIds.size(); ++i) {
                Long id = this._preferredAccountIds.get(i);
                Optional<ClientAccount> account = accounts.stream().filter(a -> a.getAccountId() == id.longValue() && !a.isDisabled()).findFirst();
                if (account.isPresent()) {
                    this._preferredAccountsList.add(account.get());
                    continue;
                }
                logger.error("Failed locate active account for preferred id {}", (Object)id);
            }
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString(this.getClass(), (String)"Common.HEADING_ACCOUNT", (String[])new String[0]);
            }
            if (column == 1) {
                return Messages.getString(this.getClass(), (String)"Common.HEADING_CODE", (String[])new String[0]);
            }
            throw new IllegalArgumentException("Unexpected column index");
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            if (this._preferredAccountsList == null) {
                return 1;
            }
            return this._preferredAccountsList.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                if (this._preferredAccountsList == null) {
                    return Messages.getString(this.getClass(), (String)"Common.LOADING", (String[])new String[0]);
                }
                ClientAccount a = this._preferredAccountsList.get(rowIndex);
                return Objects.requireNonNullElse(a, "--error--");
            }
            if (columnIndex == 1) {
                ClientAccount a = this._preferredAccountsList.get(rowIndex);
                if (a != null) {
                    return a.getFullPin();
                }
                return "";
            }
            throw new IllegalArgumentException("unexpected column index");
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }
    }
}

